/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import cofh.api.energy.IEnergyConnection;
import java.util.Map;
import mcjty.entity.GenericEnergyHandlerTileEntity;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.network.Argument;
import mcjty.varia.EnergyTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RelayTileEntity
extends GenericEnergyHandlerTileEntity {
    public static final int MAXENERGY = 30000;
    public static final int RECEIVEPERTICK = 20000;
    public static final String CMD_SETTINGS = "settings";
    private int rfOn = 1000;
    private int rfOff = 0;

    public RelayTileEntity() {
        super(30000, 20000);
    }

    @Override
    protected void checkStateServer() {
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int rf = BlockTools.getRedstoneSignal(meta) ? this.rfOn : this.rfOff;
        if (rf <= 0) {
            return;
        }
        int energyStored = this.getEnergyStored(ForgeDirection.DOWN);
        if (energyStored <= 0) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int rfToGive;
            int received;
            ForgeDirection opposite;
            IEnergyConnection connection;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!EnergyTools.isEnergyTE(te) || !(connection = (IEnergyConnection)te).canConnectEnergy(opposite = dir.getOpposite()) || (energyStored -= this.extractEnergy(ForgeDirection.DOWN, received = EnergyTools.receiveEnergy(te, opposite, rfToGive = rf <= energyStored ? rf : energyStored), false)) > 0) continue;
            return;
        }
    }

    public int getRfOn() {
        return this.rfOn;
    }

    public void setRfOn(int rfOn) {
        this.rfOn = rfOn;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getRfOff() {
        return this.rfOff;
    }

    public void setRfOff(int rfOff) {
        this.rfOff = rfOff;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.rfOn = tagCompound.func_74762_e("rfOn");
        this.rfOff = tagCompound.func_74762_e("rfOff");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("rfOn", this.rfOn);
        tagCompound.func_74768_a("rfOff", this.rfOff);
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            this.setRfOn(args.get("on").getInteger());
            this.setRfOff(args.get("off").getInteger());
            return true;
        }
        return false;
    }
}

