/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.crafter.CrafterConfiguration;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.network.Argument;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class CrafterBaseTE
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final int SPEED_SLOW = 0;
    public static final int SPEED_FAST = 1;
    public static final String CMD_MODE = "mode";
    private InventoryHelper inventoryHelper = new InventoryHelper(this, CrafterContainer.factory, 40);
    private CraftingRecipe[] recipes;
    private int supportedRecipes;
    private RedstoneMode redstoneMode = RedstoneMode.REDSTONE_IGNORED;
    private int speedMode = 0;

    public CrafterBaseTE() {
        super(CrafterConfiguration.MAXENERGY, CrafterConfiguration.RECEIVEPERTICK);
        this.setSupportedRecipes(8);
    }

    public void setSupportedRecipes(int supportedRecipes) {
        this.supportedRecipes = supportedRecipes;
        this.recipes = new CraftingRecipe[supportedRecipes];
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public int getSupportedRecipes() {
        return this.supportedRecipes;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getSpeedMode() {
        return this.speedMode;
    }

    public void setSpeedMode(int speedMode) {
        this.speedMode = speedMode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getStacks().length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStacks()[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Crafter Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        return CrafterContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return CrafterContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return CrafterContainer.factory.isOutputSlot(index);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.readRecipesFromNBT(tagCompound);
        int m = tagCompound.func_74762_e("rsMode");
        this.redstoneMode = RedstoneMode.values()[m];
        this.speedMode = tagCompound.func_74771_c("speedMode");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.getStacks()[i + 10] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    private void readRecipesFromNBT(NBTTagCompound tagCompound) {
        NBTTagList recipeTagList = tagCompound.func_150295_c("Recipes", 10);
        for (int i = 0; i < recipeTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = recipeTagList.func_150305_b(i);
            this.recipes[i].readFromNBT(nbtTagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        this.writeRecipesToNBT(tagCompound);
        tagCompound.func_74774_a("rsMode", (byte)this.redstoneMode.ordinal());
        tagCompound.func_74774_a("speedMode", (byte)this.speedMode);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 10; i < this.inventoryHelper.getStacks().length; ++i) {
            ItemStack stack = this.inventoryHelper.getStacks()[i];
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    private void writeRecipesToNBT(NBTTagCompound tagCompound) {
        NBTTagList recipeTagList = new NBTTagList();
        for (CraftingRecipe recipe : this.recipes) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            recipe.writeToNBT(nbtTagCompound);
            recipeTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Recipes", (NBTBase)recipeTagList);
    }

    @Override
    protected void checkStateServer() {
        super.checkStateServer();
        if (this.redstoneMode != RedstoneMode.REDSTONE_IGNORED) {
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean rs = BlockTools.getRedstoneSignal(meta);
            if (this.redstoneMode == RedstoneMode.REDSTONE_OFFREQUIRED && rs) {
                return;
            }
            if (this.redstoneMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                return;
            }
        }
        int steps = 1;
        if (this.speedMode == 1) {
            steps = CrafterConfiguration.speedOperations;
        }
        for (int i = 0; i < steps; ++i) {
            this.craftOneCycle();
        }
    }

    private void craftOneCycle() {
        int rf = (int)((float)CrafterConfiguration.rfPerOperation * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return;
        }
        boolean energyConsumed = false;
        for (int index = 0; index < this.supportedRecipes; ++index) {
            CraftingRecipe craftingRecipe = this.recipes[index];
            if (craftingRecipe == null || !this.checkIfRecipeWorks(craftingRecipe) || !this.craftOneItem(craftingRecipe)) continue;
            energyConsumed = true;
        }
        if (energyConsumed) {
            this.consumeEnergy(rf);
        }
    }

    private boolean craftOneItem(CraftingRecipe craftingRecipe) {
        ArrayList<InventoryHelper.SlotModifier> undo = new ArrayList<InventoryHelper.SlotModifier>();
        int amountLeft = this.placeResult(craftingRecipe.isCraftInternal(), craftingRecipe.getResult(), undo);
        if (amountLeft == 0 && !craftingRecipe.getContainerItems().isEmpty()) {
            for (ItemStack stack : craftingRecipe.getContainerItems()) {
                amountLeft = this.placeResult(craftingRecipe.isCraftInternal(), stack, undo);
                if (amountLeft == 0) continue;
                break;
            }
        }
        if (amountLeft == 0) {
            this.consumeCraftingItems(craftingRecipe.getStacksWithCount(), craftingRecipe.isKeepOne() ? 1 : 0);
            return true;
        }
        for (InventoryHelper.SlotModifier modifier : undo) {
            this.inventoryHelper.getStacks()[modifier.getSlot()] = modifier.getOld();
        }
        return false;
    }

    private boolean checkIfRecipeWorks(CraftingRecipe craftingRecipe) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(this.field_145850_b);
        if (recipe == null) {
            return false;
        }
        List<CraftingRecipe.StackWithCount> stackWithCounts = craftingRecipe.getStacksWithCount();
        int keep = craftingRecipe.isKeepOne() ? 1 : 0;
        for (CraftingRecipe.StackWithCount stackWithCount : stackWithCounts) {
            ItemStack stack = stackWithCount.getStack();
            int count = stackWithCount.getCount();
            for (int j = 0; j < 26; ++j) {
                ItemStack input = this.inventoryHelper.getStacks()[10 + j];
                if (input == null || input.field_77994_a <= keep || !OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                int ss = count;
                if (input.field_77994_a - ss < keep) {
                    ss = input.field_77994_a - keep;
                }
                count -= ss;
            }
            if (count <= 0) continue;
            return false;
        }
        ItemStack result = craftingRecipe.getResult();
        return result != null;
    }

    private void consumeCraftingItems(List<CraftingRecipe.StackWithCount> stackWithCounts, int keep) {
        for (CraftingRecipe.StackWithCount stackWithCount : stackWithCounts) {
            ItemStack stack = stackWithCount.getStack();
            int count = stackWithCount.getCount();
            for (int j = 0; j < 26; ++j) {
                ItemStack input = this.inventoryHelper.getStacks()[10 + j];
                if (input == null || input.field_77994_a <= keep || !OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                int ss = count;
                if (input.field_77994_a - ss < keep) {
                    ss = input.field_77994_a - keep;
                }
                count -= ss;
                input.func_77979_a(ss);
                if (input.field_77994_a != 0) continue;
                this.inventoryHelper.getStacks()[10 + j] = null;
            }
        }
    }

    private int placeResult(boolean internal, ItemStack result, List<InventoryHelper.SlotModifier> undo) {
        int stop;
        int start;
        if (internal) {
            start = 10;
            stop = 36;
        } else {
            start = 36;
            stop = 40;
        }
        return InventoryHelper.mergeItemStack((IInventory)this, result, start, stop, undo);
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRedstoneMode(RedstoneMode.getMode(m));
            this.setSpeedMode(args.get("speed").getInteger());
            return true;
        }
        return false;
    }
}

