/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.rail;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.rail.CartLinkUtil;
import crazypants.enderio.rail.PacketTeleportEffects;
import crazypants.enderio.rail.PlayerTeleportHandler;
import crazypants.enderio.rail.TeleportUtil;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.MetadataUtil;
import crazypants.util.RoundRobinIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEnderRail
extends BlockRail
implements IResourceTooltipProvider {
    private IIcon iconEastWest;
    private IIcon iconEastWestTurned;
    private int linkId;

    public static boolean isReverse(int meta) {
        return MetadataUtil.isBitSet(3, meta);
    }

    public static ForgeDirection getDirection(int meta) {
        ForgeDirection result = BlockEnderRail.isEastWest(meta) ? ForgeDirection.EAST : ForgeDirection.SOUTH;
        if (BlockEnderRail.isReverse(meta)) {
            result = result.getOpposite();
        }
        return result;
    }

    private static boolean isEastWest(int meta) {
        return MetadataUtil.isBitSet(0, meta);
    }

    public static BlockEnderRail create() {
        PacketHandler.INSTANCE.registerMessage(PacketTeleportEffects.class, PacketTeleportEffects.class, PacketHandler.nextID(), Side.CLIENT);
        BlockEnderRail res = new BlockEnderRail();
        res.init();
        if (Config.enderRailTeleportPlayers) {
            FMLCommonHandler.instance().bus().register((Object)PlayerTeleportHandler.instance);
        }
        return res;
    }

    protected BlockEnderRail() {
        this.func_149663_c(ModObject.blockEnderRail.unlocalisedName);
        this.func_149672_a(Block.field_149777_j);
        if (Config.transceiverEnabled && Config.enderRailEnabled) {
            this.func_149647_a(EnderIOTab.tabEnderIO);
        }
        this.func_149658_d("enderio:blockEnderRail");
        this.func_149711_c(0.7f);
        this.func_149672_a(field_149777_j);
    }

    private void init() {
        GameRegistry.registerBlock((Block)this, (String)ModObject.blockEnderRail.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        this.iconEastWest = register.func_94245_a("enderio:blockEnderRailEastWest");
        this.iconEastWestTurned = register.func_94245_a("enderio:blockEnderRailEastWest_turned");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (!BlockEnderRail.isEastWest(meta)) {
            return super.func_149691_a(side, meta);
        }
        if (BlockEnderRail.isReverse(meta)) {
            return this.iconEastWestTurned;
        }
        return this.iconEastWest;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (ToolUtil.isToolEquipped(player)) {
            if (!world.field_72995_K) {
                int meta = world.func_72805_g(x, y, z);
                meta = MetadataUtil.setBit(3, !MetadataUtil.isBitSet(3, meta), meta);
                world.func_72921_c(x, y, z, meta, 2);
            }
            return true;
        }
        return false;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y - 1, z)) instanceof TileTransceiver) {
            ((TileTransceiver)te).getRailController().dropNonSpawnedCarts();
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public int getBasicRailMetadata(IBlockAccess world, EntityMinecart cart, int x, int y, int z) {
        return world.func_72805_g(x, y, z) & 7;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) == EnderIO.blockTransceiver;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.func_149742_c(world, x, y, z);
    }

    public boolean isFlexibleRail(IBlockAccess world, int y, int x, int z) {
        return false;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int origMeta;
        if (world.field_72995_K) {
            return;
        }
        int newMeta = origMeta = world.func_72805_g(x, y, z);
        if (this.field_150053_a) {
            newMeta = origMeta & 7;
        }
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        } else {
            this.func_150048_a(world, x, y, z, origMeta, newMeta, block);
        }
    }

    public void onMinecartPass(World world, EntityMinecart cart, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y - 1, z);
        if (!(te instanceof TileTransceiver)) {
            return;
        }
        TileTransceiver ter = (TileTransceiver)te;
        if (ter.getRailController().isRecievedCart(cart)) {
            return;
        }
        this.tryTeleport(world, cart, x, y, z);
    }

    private void tryTeleport(World world, EntityMinecart cart, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y - 1, z);
        if (!(te instanceof TileTransceiver)) {
            return;
        }
        TileTransceiver sender = (TileTransceiver)te;
        if (!sender.isRedstoneChecksPassed()) {
            return;
        }
        if (!sender.hasPower()) {
            return;
        }
        List<Channel> sendChannels = sender.getSendChannels(ChannelType.RAIL);
        for (Channel channel : sendChannels) {
            RoundRobinIterator<TileTransceiver> iter = ServerChannelRegister.instance.getIterator(channel);
            for (TileTransceiver reciever : iter) {
                if (!this.isValidDestination(sender, channel, reciever)) continue;
                int requiredPower = this.getPowerRequired(cart, sender, reciever);
                if (sender.getEnergyStored() < requiredPower || !this.teleportCart(world, cart, sender, reciever)) continue;
                sender.usePower(requiredPower);
                return;
            }
        }
    }

    private boolean isValidDestination(TileTransceiver sender, Channel channel, TileTransceiver reciever) {
        if (reciever == sender) {
            return false;
        }
        if (!reciever.getRecieveChannels(ChannelType.RAIL).contains(channel)) {
            return false;
        }
        if (!reciever.isRedstoneChecksPassed() || !sender.isRedstoneChecksPassed()) {
            return false;
        }
        if (!reciever.hasPower()) {
            return false;
        }
        Block blk = reciever.func_145831_w().func_147439_a(reciever.field_145851_c, reciever.field_145848_d + 1, reciever.field_145849_e);
        if (blk != EnderIO.blockEnderRail) {
            return false;
        }
        return reciever.getRailController().isClear();
    }

    private int getPowerRequired(EntityMinecart cart, TileTransceiver sender, TileTransceiver reciever) {
        int powerPerCart = this.getPowerRequiredForSingleCart(sender, reciever);
        int numCarts = CartLinkUtil.instance.getNumberOfCartsInTrain(cart);
        return powerPerCart * numCarts;
    }

    private int getPowerRequiredForSingleCart(TileTransceiver sender, TileTransceiver reciever) {
        int powerRequired = 0;
        if (sender.func_145831_w().field_73011_w.field_76574_g != reciever.func_145831_w().field_73011_w.field_76574_g) {
            powerRequired = Config.enderRailPowerRequireCrossDimensions;
        } else {
            powerRequired += sender.getLocation().distance(reciever.getLocation()) * Config.enderRailPowerRequiredPerBlock;
            if (Config.enderRailCapSameDimensionPowerAtCrossDimensionCost) {
                powerRequired = Math.min(powerRequired, Config.enderRailPowerRequireCrossDimensions);
            }
        }
        return powerRequired;
    }

    private boolean teleportCart(World world, EntityMinecart cart, TileTransceiver sender, TileTransceiver reciever) {
        List<EntityMinecart> allCarts = CartLinkUtil.instance.getCartsInTrain(cart);
        if (allCarts.size() > 1) {
            CartLinkUtil.instance.updateCartLinks(world, cart);
        }
        ArrayList<List<Entity>> toTeleport = new ArrayList<List<Entity>>(allCarts.size());
        ArrayList<EntityMinecart> toDespawn = new ArrayList<EntityMinecart>(allCarts.size());
        EntityPlayerMP playerToTP = null;
        EntityMinecart playerToMount = null;
        for (EntityMinecart cartInTrain : allCarts) {
            List<Entity> entities;
            if (cartInTrain == null || (entities = TeleportUtil.createEntitiesForReciever(cartInTrain, sender, reciever)) == null) continue;
            toTeleport.add(entities);
            toDespawn.add(cartInTrain);
            if (!Config.enderRailTeleportPlayers || !(cartInTrain.field_70153_n instanceof EntityPlayerMP)) continue;
            playerToTP = (EntityPlayerMP)cartInTrain.field_70153_n;
            playerToMount = this.getCart(entities);
        }
        for (EntityMinecart despawnCart : toDespawn) {
            TeleportUtil.spawnTeleportEffects(world, (Entity)despawnCart);
            TeleportUtil.despawn(sender.func_145831_w(), despawnCart);
        }
        reciever.getRailController().onTrainRecieved(toTeleport);
        if (playerToTP != null) {
            PlayerTeleportHandler.instance.teleportPlayer(reciever, playerToTP, playerToMount);
        }
        return true;
    }

    private EntityMinecart getCart(List<Entity> entities) {
        for (Entity ent : entities) {
            if (!(ent instanceof EntityMinecart)) continue;
            return (EntityMinecart)ent;
        }
        return null;
    }
}

