/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs.golem;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.utilityMobs.ai.EntityAIGolemTarget;
import toast.utilityMobs.ai.EntityAIWeaponAttack;
import toast.utilityMobs.golem.EntityLargeGolem;
import toast.utilityMobs.network.GuiHelper;

public class EntitySteamGolem
extends EntityLargeGolem
implements IInventory {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("UtilityMobs:textures/models/golem/steamGolem.png"), new ResourceLocation("UtilityMobs:textures/models/golem/steamGolem_fire.png")};
    public int burnTime = 0;
    public int maxBurnTime = 0;
    private ItemStack[] contents = new ItemStack[3];

    public EntitySteamGolem(World world) {
        super(world);
        this.texture = TEXTURES[0];
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.sitAI);
        this.sitAI.func_75248_a(7);
        this.sitAI.sitAnywhere = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWeaponAttack(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIGolemTarget(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + 2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)0);
    }

    public boolean getBurningState() {
        return this.field_70180_af.func_75683_a(30) == 1;
    }

    public void setBurningState(boolean state) {
        this.field_70180_af.func_75692_b(30, (Object)(state ? (byte)1 : 0));
    }

    @Override
    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150460_al);
    }

    @Override
    protected void dropFewItems(boolean recentlyHit, int looting, float dropChance) {
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_145779_a(this.func_146068_u(), 1);
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.contents[i] == null) continue;
            ItemStack split = this.contents[i].func_77946_l();
            while (this.contents[i].field_77994_a > 0) {
                int splitSize = this.field_70146_Z.nextInt(21) + 10;
                if (splitSize > this.contents[i].field_77994_a) {
                    splitSize = this.contents[i].field_77994_a;
                }
                this.contents[i].field_77994_a -= splitSize;
                split.field_77994_a = splitSize;
                this.func_70099_a(split, 0.0f);
            }
            this.contents[i] = null;
        }
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return TileEntityFurnace.func_145954_b((ItemStack)itemStack);
    }

    public int func_70302_i_() {
        return 3;
    }

    public String func_145825_b() {
        return this.func_94056_bM() ? this.func_94057_bL() : "Furnace Golem";
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (this.canInteract(player) && !player.func_70093_af() && this.openGUI(player)) {
            return true;
        }
        return super.func_70085_c(player);
    }

    public boolean openGUI(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            GuiHelper.displayGUICustom(player, (Entity)this);
        }
        return true;
    }

    @Override
    public int getUsePermissions() {
        return super.getUsePermissions() | 4;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.texture = this.getBurningState() ? TEXTURES[1] : TEXTURES[0];
        }
    }

    @Override
    public void func_70636_d() {
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean burnState;
            if (this.func_70301_a(1) == null || TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1)) <= 0) {
                ItemStack current = this.func_70301_a(1);
                for (int slot = 0; slot < this.contents.length; ++slot) {
                    if (slot == 1 || this.func_70301_a(slot) == null || TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(slot)) <= 0) continue;
                    this.func_70299_a(1, this.func_70301_a(slot));
                    this.func_70299_a(slot, current);
                    break;
                }
            }
            if (this.burnTime == 0) {
                this.maxBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1));
                if (this.burnTime > 0 && this.func_70301_a(1) != null) {
                    --this.func_70301_a((int)1).field_77994_a;
                    if (this.func_70301_a((int)1).field_77994_a == 0) {
                        this.func_70299_a(1, this.func_70301_a(1).func_77973_b().getContainerItem(this.func_70301_a(1)));
                    }
                }
            }
            boolean bl = burnState = this.burnTime > 0;
            if (this.getBurningState() != burnState) {
                this.setBurningState(burnState);
            }
            this.sitAI.sit = !burnState;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.contents.length; ++slot) {
            if (this.contents[slot] == null) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)slot);
            this.contents[slot].func_77955_b(slotTag);
            tagList.func_74742_a((NBTBase)slotTag);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        tag.func_74777_a("BurnTime", (short)this.burnTime);
        tag.func_74777_a("MaxBurnTime", (short)this.maxBurnTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", (int)tag.func_74732_a());
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound slotTag = tagList.func_150305_b(i);
            int slot = slotTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.func_77949_a((NBTTagCompound)slotTag);
        }
        this.burnTime = tag.func_74765_d("BurnTime");
        this.maxBurnTime = tag.func_74765_d("MaxBurnTime");
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int max) {
        if (this.maxBurnTime == 0) {
            this.maxBurnTime = 200;
        }
        return this.burnTime * max / this.maxBurnTime;
    }

    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.contents[slot] != null) {
            if (this.contents[slot].field_77994_a <= amount) {
                ItemStack itemStack = this.contents[slot];
                this.contents[slot] = null;
                return itemStack;
            }
            ItemStack itemStack = this.contents[slot].func_77979_a(amount);
            if (this.contents[slot].field_77994_a == 0) {
                this.contents[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.contents[slot] != null) {
            ItemStack itemStack = this.contents[slot];
            this.contents[slot] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.contents[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canInteract(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

