/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.entity.GenericTileEntity;
import mcjty.entity.SyncedValue;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.blocks.monitor.GuiRFMonitor;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import mcjty.rftools.network.Argument;
import mcjty.varia.Coordinate;
import mcjty.varia.EnergyTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class RFMonitorBlockTileEntity
extends GenericTileEntity {
    private int monitorX = -1;
    private int monitorY = -1;
    private int monitorZ = -1;
    private RFMonitorMode alarmMode = RFMonitorMode.MODE_OFF;
    private int alarmLevel = 0;
    public static final String CMD_GETADJACENTBLOCKS = "getAdj";
    public static final String CLIENTCMD_ADJACENTBLOCKSREADY = "adjReady";
    private int counter = 20;
    private SyncedValue<Integer> rflevel = new SyncedValue<Integer>(0);
    private SyncedValue<Boolean> inAlarm = new SyncedValue<Boolean>(false);

    public RFMonitorBlockTileEntity() {
        this.registerSyncedObject(this.rflevel);
        this.registerSyncedObject(this.inAlarm);
    }

    public RFMonitorMode getAlarmMode() {
        return this.alarmMode;
    }

    public int getAlarmLevel() {
        return this.alarmLevel;
    }

    public void setAlarm(RFMonitorMode mode, int level) {
        this.alarmMode = mode;
        this.alarmLevel = level;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getMonitorX() {
        return this.monitorX;
    }

    public int getMonitorY() {
        return this.monitorY;
    }

    public int getMonitorZ() {
        return this.monitorZ;
    }

    public boolean isValid() {
        return this.monitorY >= 0;
    }

    @Override
    public void setInvalid() {
        this.monitorX = -1;
        this.monitorY = -1;
        this.monitorZ = -1;
        super.setInvalid();
    }

    public void setMonitor(Coordinate c) {
        this.monitorX = c.getX();
        this.monitorY = c.getY();
        this.monitorZ = c.getZ();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getRflevel() {
        Integer value = this.rflevel.getValue();
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        Boolean value = this.inAlarm.getValue();
        return BlockTools.setRedstoneSignal(meta, value == null ? false : value);
    }

    public List<Coordinate> findAdjacentBlocks() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ArrayList<Coordinate> adjacentBlocks = new ArrayList<Coordinate>();
        for (int dy = -1; dy <= 1; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.field_145850_b.func_72940_L()) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                int zz = z + dz;
                for (int dx = -1; dx <= 1; ++dx) {
                    TileEntity tileEntity;
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0 || (tileEntity = this.field_145850_b.func_147438_o(xx, yy, zz)) == null || !EnergyTools.isEnergyTE(tileEntity)) continue;
                    adjacentBlocks.add(new Coordinate(xx, yy, zz));
                }
            }
        }
        return adjacentBlocks;
    }

    @Override
    protected void checkStateServer() {
        Boolean v;
        boolean alarmValue;
        if (!this.isValid()) {
            this.counter = 1;
            return;
        }
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.monitorX, this.monitorY, this.monitorZ);
        if (!EnergyTools.isEnergyTE(tileEntity)) {
            this.setInvalid();
            return;
        }
        EnergyTools.EnergyLevel energy = EnergyTools.getEnergyLevel(tileEntity);
        long maxEnergy = energy.getMaxEnergy();
        int ratio = 0;
        boolean alarm = false;
        if (maxEnergy > 0L) {
            long stored = energy.getEnergy();
            ratio = (int)(1L + stored * 5L / maxEnergy);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            switch (this.alarmMode) {
                case MODE_OFF: {
                    alarm = false;
                    break;
                }
                case MODE_LESS: {
                    alarm = stored * 100L / maxEnergy < (long)this.alarmLevel;
                    break;
                }
                case MODE_MORE: {
                    alarm = stored * 100L / maxEnergy > (long)this.alarmLevel;
                }
            }
        }
        boolean bl = alarmValue = (v = this.inAlarm.getValue()) == null ? false : v;
        if (this.getRflevel() != ratio || alarm != alarmValue) {
            this.rflevel.setValue(ratio);
            if (alarmValue != alarm) {
                this.inAlarm.setValue(alarm);
            }
            this.notifyBlockUpdate();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.monitorX = tagCompound.func_74762_e("monitorX");
        this.monitorY = tagCompound.func_74762_e("monitorY");
        this.monitorZ = tagCompound.func_74762_e("monitorZ");
        this.inAlarm.setValue(tagCompound.func_74767_n("inAlarm"));
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.rflevel.setValue(tagCompound.func_74762_e("rflevel"));
        this.alarmMode = RFMonitorMode.getModeFromIndex(tagCompound.func_74771_c("alarmMode"));
        this.alarmLevel = tagCompound.func_74771_c("alarmLevel");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("monitorX", this.monitorX);
        tagCompound.func_74768_a("monitorY", this.monitorY);
        tagCompound.func_74768_a("monitorZ", this.monitorZ);
        Boolean value = this.inAlarm.getValue();
        tagCompound.func_74757_a("inAlarm", value == null ? false : value);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("rflevel", this.getRflevel());
        tagCompound.func_74774_a("alarmMode", (byte)this.alarmMode.getIndex());
        tagCompound.func_74774_a("alarmLevel", (byte)this.alarmLevel);
    }

    @Override
    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETADJACENTBLOCKS.equals(command)) {
            return this.findAdjacentBlocks();
        }
        return null;
    }

    @Override
    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_ADJACENTBLOCKSREADY.equals(command)) {
            GuiRFMonitor.fromServer_clientAdjacentBlocks = new ArrayList<Coordinate>(list);
            return true;
        }
        return false;
    }
}

