/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Map;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletScramblerContainer;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.PacketHandler;
import mcjty.rftools.network.PacketRequestIntegerFromServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class DimletScramblerTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final String CMD_GETSCRAMBLING = "getScrambling";
    public static final String CLIENTCMD_GETSCRAMBLING = "getScrambling";
    private InventoryHelper inventoryHelper = new InventoryHelper(this, DimletScramblerContainer.factory, 4);
    private int scrambling = 0;
    private float bonus = 0.0f;

    public int getScrambling() {
        return this.scrambling;
    }

    public DimletScramblerTileEntity() {
        super(DimletConfiguration.SCRAMBLER_MAXENERGY, DimletConfiguration.SCRAMBLER_RECEIVEPERTICK);
    }

    @Override
    protected void checkStateServer() {
        if (this.scrambling > 0) {
            --this.scrambling;
            if (this.scrambling == 0) {
                DimletKey key = DimletRandomizer.getRandomDimlet(this.bonus, this.field_145850_b.field_73012_v);
                InventoryHelper.mergeItemStack((IInventory)this, KnownDimletConfiguration.makeKnownDimlet(key, this.field_145850_b), 3, 4, new ArrayList<InventoryHelper.SlotModifier>());
            }
            this.func_70296_d();
        } else {
            ItemStack input1 = this.inventoryHelper.getStacks()[0];
            ItemStack input2 = this.inventoryHelper.getStacks()[1];
            ItemStack input3 = this.inventoryHelper.getStacks()[2];
            ItemStack outputStack = this.inventoryHelper.getStacks()[3];
            if (this.isValidInput(input1, input2, input3) && outputStack == null) {
                this.startScrambling();
            }
        }
    }

    private boolean isValidInput(ItemStack input1, ItemStack input2, ItemStack input3) {
        if (input1 == null || input2 == null || input3 == null) {
            return false;
        }
        if (input1.func_77973_b() != ModItems.knownDimlet || input2.func_77973_b() != ModItems.knownDimlet || input3.func_77973_b() != ModItems.knownDimlet) {
            return false;
        }
        DimletKey key1 = KnownDimletConfiguration.getDimletKey(input1, this.field_145850_b);
        DimletKey key2 = KnownDimletConfiguration.getDimletKey(input2, this.field_145850_b);
        DimletKey key3 = KnownDimletConfiguration.getDimletKey(input3, this.field_145850_b);
        int cntCraftable = (KnownDimletConfiguration.craftableDimlets.contains(key1) ? 1 : 0) + (KnownDimletConfiguration.craftableDimlets.contains(key2) ? 1 : 0) + (KnownDimletConfiguration.craftableDimlets.contains(key3) ? 1 : 0);
        return cntCraftable <= 1;
    }

    private void startScrambling() {
        int rf = DimletConfiguration.rfScrambleOperation;
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return;
        }
        ItemStack[] input = this.inventoryHelper.getStacks();
        DimletKey key1 = KnownDimletConfiguration.getDimletKey(input[0], this.field_145850_b);
        DimletKey key2 = KnownDimletConfiguration.getDimletKey(input[1], this.field_145850_b);
        DimletKey key3 = KnownDimletConfiguration.getDimletKey(input[2], this.field_145850_b);
        DimletEntry entry1 = KnownDimletConfiguration.getEntry(key1);
        if (entry1 == null) {
            return;
        }
        DimletEntry entry2 = KnownDimletConfiguration.getEntry(key2);
        if (entry2 == null) {
            return;
        }
        DimletEntry entry3 = KnownDimletConfiguration.getEntry(key3);
        if (entry3 == null) {
            return;
        }
        this.consumeEnergy(rf);
        input[0].func_77979_a(1);
        if (input[0].field_77994_a == 0) {
            input[0] = null;
        }
        input[1].func_77979_a(1);
        if (input[1].field_77994_a == 0) {
            input[1] = null;
        }
        input[2].func_77979_a(1);
        if (input[2].field_77994_a == 0) {
            input[2] = null;
        }
        int rarity1 = entry1.getRarity();
        int rarity2 = entry2.getRarity();
        int rarity3 = entry3.getRarity();
        float b = (float)(rarity1 + rarity2 + rarity3) / 3.0f;
        this.bonus = b / 50.0f * (this.getInfusedFactor() / 3.0f + 1.0f);
        this.scrambling = 64;
        this.func_70296_d();
    }

    public void requestScramblingFromServer() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getScrambling", "getScrambling", new Argument[0]));
    }

    @Override
    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getScrambling".equals(command)) {
            return this.scrambling;
        }
        return null;
    }

    @Override
    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getScrambling".equals(command)) {
            this.scrambling = result;
            return true;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return DimletScramblerContainer.factory.isInputSlot(index) || DimletScramblerContainer.factory.isSpecificItemSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return DimletScramblerContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getStacks().length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStacks()[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Scrambler Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.scrambling = tagCompound.func_74762_e("scrambling");
        this.bonus = tagCompound.func_74760_g("bonus");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.getStacks()[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("scrambling", this.scrambling);
        tagCompound.func_74776_a("bonus", this.bonus);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getStacks().length; ++i) {
            ItemStack stack = this.inventoryHelper.getStacks()[i];
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }
}

