/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import toast.utilityMobs.colossal.EntityColossalGolem;

public class ModelColossalGolem
extends ModelBase {
    private static final float TO_RADS = (float)Math.PI / 180;
    public ModelRenderer head = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
    public ModelRenderer body;
    public ModelRenderer lower;
    public ModelRenderer armRight;
    public ModelRenderer forearmRight;
    public ModelRenderer armLeft;
    public ModelRenderer legRight;
    public ModelRenderer lowerLegRight;
    public ModelRenderer legLeft;
    public ModelRenderer lowerLegLeft;
    public ModelRenderer forearmLeft;

    public ModelColossalGolem() {
        this.head.func_78793_a(0.0f, -9.0f, -5.0f);
        this.head.func_78784_a(0, 0).func_78789_a(-5.0f, -8.0f, -10.5f, 10, 12, 10);
        this.head.func_78784_a(30, 0).func_78789_a(-1.5f, 0.0f, -13.5f, 3, 5, 3);
        this.body = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.body.func_78793_a(0.0f, -9.0f, -2.0f);
        this.body.func_78784_a(0, 22).func_78789_a(-12.0f, -4.0f, -8.0f, 24, 18, 16);
        this.lower = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.lower.func_78793_a(0.0f, -9.0f, -2.0f);
        this.lower.func_78784_a(4, 56).func_78789_a(-6.0f, 8.0f, 3.0f, 12, 11, 10);
        this.armRight = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.armRight.func_78793_a(0.0f, -9.0f, -2.0f);
        this.armRight.func_78784_a(56, 56).func_78789_a(-16.0f, -4.5f, -3.0f, 4, 18, 6);
        this.forearmRight = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.forearmRight.func_78793_a(0.0f, -9.0f, -2.0f);
        this.forearmRight.func_78784_a(52, 80).func_78789_a(-17.0f, 10.0f, -1.0f, 6, 18, 8);
        this.armLeft = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.armLeft.func_78793_a(0.0f, -9.0f, -2.0f);
        this.armLeft.func_78784_a(84, 56).func_78789_a(12.0f, -4.5f, -3.0f, 4, 18, 6);
        this.forearmLeft = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.forearmLeft.func_78793_a(0.0f, -9.0f, -2.0f);
        this.forearmLeft.func_78784_a(80, 80).func_78789_a(11.0f, 10.0f, -1.0f, 6, 18, 8);
        this.legRight = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.legRight.func_78793_a(-5.0f, 9.0f, 8.0f);
        this.legRight.func_78784_a(2, 77).func_78789_a(-3.5f, -5.0f, -3.0f, 6, 12, 5);
        this.lowerLegRight = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.lowerLegRight.func_78793_a(-5.0f, 9.0f, 8.0f);
        this.lowerLegRight.func_78784_a(0, 94).func_78789_a(-4.0f, 2.0f, -7.0f, 7, 13, 6);
        this.legLeft = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.legLeft.func_78793_a(5.0f, 9.0f, 8.0f);
        this.legLeft.func_78784_a(28, 77).func_78789_a(-2.5f, -5.0f, -3.0f, 6, 12, 5);
        this.lowerLegLeft = new ModelRenderer((ModelBase)this).func_78787_b(128, 128);
        this.lowerLegLeft.func_78793_a(5.0f, 9.0f, 8.0f);
        this.lowerLegLeft.func_78784_a(26, 94).func_78789_a(-3.0f, 2.0f, -7.0f, 7, 13, 6);
    }

    public void func_78088_a(Entity entity, float time, float moveSpeed, float rotationFloat, float rotationYaw, float rotationPitch, float scale) {
        this.animate((EntityColossalGolem)entity, time, moveSpeed, rotationFloat, rotationYaw, rotationPitch, scale);
        this.head.func_78785_a(scale);
        this.body.func_78785_a(scale);
        this.lower.func_78785_a(scale);
        this.armRight.func_78785_a(scale);
        this.forearmRight.func_78785_a(scale);
        this.armLeft.func_78785_a(scale);
        this.forearmLeft.func_78785_a(scale);
        this.legRight.func_78785_a(scale);
        this.lowerLegRight.func_78785_a(scale);
        this.legLeft.func_78785_a(scale);
        this.lowerLegLeft.func_78785_a(scale);
    }

    private float adjust(float f, float f1) {
        return (Math.abs(f % f1 - f1 * 0.5f) - f1 * 0.25f) / (f1 * 0.25f);
    }

    private void setAngles(EntityColossalGolem golem, float time, float moveSpeed, float rotationFloat, float rotationYaw, float rotationPitch, float scale) {
        this.head.field_78796_g = this.rad(rotationYaw);
        this.head.field_78795_f = this.rad(rotationPitch);
        this.body.field_78795_f = this.rad(48.0f);
        this.body.field_78796_g = 0.0f;
        this.body.field_78808_h = 0.0f;
        this.lower.field_78795_f = this.rad(12.0f);
        this.armRight.func_78793_a(0.0f, -9.0f, -2.0f);
        this.armRight.field_78795_f = this.rad(12.0f) - 1.5f * this.adjust(time, 13.0f) * moveSpeed;
        this.armRight.field_78796_g = 0.0f;
        this.armRight.field_78808_h = this.rad(6.0f);
        this.forearmRight.func_78793_a(0.0f, -9.0f, -2.0f);
        this.forearmRight.field_78795_f = this.rad(-5.0f) - 1.5f * this.adjust(time, 13.0f) * moveSpeed;
        this.forearmRight.field_78796_g = 0.0f;
        this.forearmRight.field_78808_h = this.rad(6.0f);
        this.armLeft.func_78793_a(0.0f, -9.0f, -2.0f);
        this.armLeft.field_78795_f = this.rad(12.0f) + 1.5f * this.adjust(time, 13.0f) * moveSpeed;
        this.armLeft.field_78796_g = 0.0f;
        this.armLeft.field_78808_h = this.rad(-6.0f);
        this.forearmLeft.func_78793_a(0.0f, -9.0f, -2.0f);
        this.forearmLeft.field_78795_f = this.rad(-5.0f) + 1.5f * this.adjust(time, 13.0f) * moveSpeed;
        this.forearmLeft.field_78796_g = 0.0f;
        this.forearmLeft.field_78808_h = this.rad(-6.0f);
        this.legLeft.field_78795_f = this.rad(-43.0f) - 1.5f * this.adjust(time, 13.0f) * moveSpeed;
        this.lowerLegLeft.field_78795_f = -1.5f * this.adjust(time, 13.0f) * moveSpeed;
        this.legRight.field_78795_f = this.rad(-43.0f) + 1.5f * this.adjust(time, 13.0f) * moveSpeed;
        this.lowerLegRight.field_78795_f = 1.5f * this.adjust(time, 13.0f) * moveSpeed;
    }

    public void animate(EntityColossalGolem golem, float time, float moveSpeed, float rotationFloat, float rotationYaw, float rotationPitch, float scale) {
        if (golem.isSitting()) {
            moveSpeed = 0.0f;
        }
        this.setAngles(golem, time, moveSpeed, rotationFloat, rotationYaw, rotationPitch, scale);
        int anim = golem.getAnimId();
        if (anim == 0) {
            return;
        }
        int tick = golem.getAnimTick();
        float progress = 0.0f;
        if (tick <= 6) {
            progress = (float)tick / 6.0f;
        } else if (tick <= 16) {
            progress = 1.0f - (float)(tick - 6) / 10.0f;
        }
        if (anim == 1) {
            this.rotate(this.body, progress, 0.0f, -16.0f, -16.0f);
            this.rotate(this.armRight, progress, -140.0f, -16.0f, -16.0f);
            this.rotate(this.forearmRight, progress, -140.0f, -20.0f, -16.0f);
            this.rotate(this.armLeft, progress, 0.0f, -16.0f, -29.0f);
            this.rotate(this.forearmLeft, progress, 0.0f, -16.0f, -16.0f);
            this.move(this.forearmLeft, progress, 0.0f, -5.0f, 0.0f);
        } else if (anim == 2) {
            this.rotate(this.body, progress, 0.0f, 16.0f, 16.0f);
            this.rotate(this.armLeft, progress, -140.0f, 16.0f, -16.0f);
            this.rotate(this.forearmLeft, progress, -140.0f, 20.0f, -16.0f);
            this.rotate(this.armRight, progress, 0.0f, 16.0f, 29.0f);
            this.rotate(this.forearmRight, progress, 0.0f, 16.0f, 16.0f);
            this.move(this.forearmRight, progress, 0.0f, -5.0f, 0.0f);
        }
    }

    private void rotate(ModelRenderer box, float progress, float x, float y, float z) {
        if (x != 0.0f) {
            box.field_78795_f += this.rad(x) * progress;
        }
        if (y != 0.0f) {
            box.field_78796_g += this.rad(y) * progress;
        }
        if (z != 0.0f) {
            box.field_78808_h += this.rad(z) * progress;
        }
    }

    private void move(ModelRenderer box, float progress, float x, float y, float z) {
        if (x != box.field_78800_c) {
            box.field_78800_c += x * progress;
        }
        if (y != box.field_78797_d) {
            box.field_78797_d += y * progress;
        }
        if (z != box.field_78798_e) {
            box.field_78798_e += z * progress;
        }
    }

    private float rad(float deg) {
        return deg * ((float)Math.PI / 180);
    }
}

