/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bdew.neiaddons.NEIAddons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;

public class ClientHandler
extends SimpleChannelInboundHandler<NBTTagCompound> {
    public static Set<String> enabledCommands = new HashSet<String>();
    private WorldClient oldworld;

    public ClientHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void handleTickEvent(TickEvent ev) {
        WorldClient world;
        if (ev.phase == TickEvent.Phase.START && ev.type == TickEvent.Type.WORLD && (world = Minecraft.func_71410_x().field_71441_e) != null && world != this.oldworld) {
            this.reset();
        }
    }

    private void reset() {
        NEIAddons.logInfo("World changed, resetting", new Object[0]);
        this.oldworld = Minecraft.func_71410_x().field_71441_e;
        enabledCommands.clear();
    }

    protected void channelRead0(ChannelHandlerContext ctx, NBTTagCompound msg) throws Exception {
        String cmd = msg.func_74779_i("cmd");
        NBTTagCompound data = msg.func_74775_l("data");
        try {
            if (cmd.equals("hello")) {
                this.reset();
                if (data.func_74762_e("version") != 1) {
                    NEIAddons.logWarning("Client/Server version mismatch! client=%d server=%d", data.func_74762_e("version"), 1);
                    return;
                }
                String cmds = data.func_74779_i("commands");
                NEIAddons.logInfo("Available server commands: %s", cmds);
                enabledCommands.addAll(Arrays.asList(StringUtils.split((String)cmds, (char)';')));
            } else {
                NEIAddons.logWarning("Uknown packet from server: %s", cmd);
            }
        }
        catch (Throwable e) {
            NEIAddons.logSevereExc(e, "Error handling packet from server", new Object[0]);
        }
    }
}

