/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.data;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityRedcrystalMerc;

public class RedstoneMirrorNetwork
extends WorldSavedData {
    protected Map<BlockCoord, Integer> highestPower = new HashMap<BlockCoord, Integer>();
    protected Map<BlockCoord, HashMap<BlockCoord, Integer>> powerLevels = new HashMap<BlockCoord, HashMap<BlockCoord, Integer>>();
    private static final int NEEDS_POWER_RECALC = -1;
    private int dimensionID = -9909;

    public RedstoneMirrorNetwork(String dataMapName) {
        super(dataMapName);
    }

    public int getSignalGoingIn(BlockCoord mirrorPos) {
        Integer strength = this.highestPower.get(mirrorPos);
        return strength == null ? 0 : (strength == -1 ? this.calculateSignal(mirrorPos) : strength.intValue());
    }

    public int getSignalGoingIn(int x, int y, int z) {
        return this.getSignalGoingIn(new BlockCoord(x, y, z));
    }

    public void contributeToSignalInto(int x, int y, int z, TileEntity te, int strength) {
        boolean newHigh;
        this.dimensionID = te.func_145831_w().field_73011_w.field_76574_g;
        BlockCoord mirrorPos = new BlockCoord(x, y, z);
        Integer currentStrength = this.highestPower.get(mirrorPos);
        if (currentStrength == null || currentStrength < strength) {
            this.highestPower.put(mirrorPos, strength);
            newHigh = true;
        } else {
            newHigh = false;
        }
        HashMap<BlockCoord, Integer> submap = this.powerLevels.get(mirrorPos);
        if (submap == null) {
            submap = new HashMap();
            this.powerLevels.put(mirrorPos, submap);
            submap.put(new BlockCoord(te), strength);
        } else {
            BlockCoord tePos = new BlockCoord(te);
            Integer prev = null;
            if (!newHigh) {
                prev = submap.get(tePos);
            }
            if (prev != null) {
                if (prev != strength) {
                    submap.put(tePos, strength);
                    if (prev == this.highestPower.get(mirrorPos)) {
                        this.highestPower.put(mirrorPos, -1);
                    }
                }
            } else {
                submap.put(tePos, strength);
            }
        }
        this.func_76185_a();
    }

    private int calculateSignal(BlockCoord mirrorPos) {
        int highest = 0;
        HashMap<BlockCoord, Integer> map = this.powerLevels.get(mirrorPos);
        if (map != null) {
            for (Map.Entry<BlockCoord, Integer> entry : map.entrySet()) {
                Integer strength = entry.getValue();
                highest = Math.max(highest, strength == null ? 0 : strength);
            }
            this.highestPower.put(mirrorPos, highest);
        }
        return highest;
    }

    public void removeSignal(int x, int y, int z) {
        BlockCoord mirrorPos = new BlockCoord(x, y, z);
        if (this.highestPower.containsKey(mirrorPos)) {
            this.highestPower.remove(mirrorPos);
            this.powerLevels.remove(mirrorPos);
            this.func_76185_a();
        }
    }

    public void removeContributor(int x, int y, int z, BlockCoord tePos) {
        this.removeContributor(new BlockCoord(x, y, z), tePos);
    }

    public void removeContributor(BlockCoord mirrorPos, BlockCoord tePos) {
        Integer prevStrength;
        HashMap<BlockCoord, Integer> submap = this.powerLevels.get(mirrorPos);
        if (submap != null && (prevStrength = submap.get(tePos)) != null) {
            submap.remove(tePos);
            this.func_76185_a();
            if (prevStrength >= this.getSignalGoingIn(mirrorPos)) {
                this.highestPower.put(mirrorPos, -1);
            }
        }
    }

    public void removeContributor(int x, int y, int z, TileEntity te) {
        this.removeContributor(x, y, z, new BlockCoord(te));
    }

    public void cleanEntries(World world, int x, int y, int z) {
        this.cleanEntries(world, new BlockCoord(x, y, z));
    }

    public void cleanEntries(World world, BlockCoord mirrorPos) {
        HashMap<BlockCoord, Integer> submap = this.powerLevels.get(mirrorPos);
        if (submap != null) {
            boolean anyInvalid = false;
            for (Map.Entry<BlockCoord, Integer> entry : submap.entrySet()) {
                BlockCoord pos = entry.getKey();
                TileEntity te = world.func_147438_o(pos.x, pos.y, pos.z);
                boolean invalid = false;
                if (te == null) {
                    if (TjUtil.isChunkLoaded(world, mirrorPos.x, mirrorPos.z)) {
                        invalid = true;
                    }
                } else if (!(te instanceof TileEntityRedcrystalMerc)) {
                    invalid = true;
                } else {
                    TileEntityRedcrystalMerc ter = (TileEntityRedcrystalMerc)te;
                    if (ter.mirrorDim != world.field_73011_w.field_76574_g || ter.mirrorX != mirrorPos.x || ter.mirrorY != mirrorPos.y || ter.mirrorZ != mirrorPos.z) {
                        invalid = true;
                    }
                }
                if (!invalid) continue;
                this.removeContributor(mirrorPos, pos);
                anyInvalid = true;
            }
            if (anyInvalid) {
                this.highestPower.put(mirrorPos, -1);
            }
        }
    }

    public void cleanEntries() {
        WorldServer world = null;
        try {
            world = MinecraftServer.func_71276_C().func_71218_a(this.dimensionID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (world == null) {
            return;
        }
        for (Map.Entry<BlockCoord, HashMap<BlockCoord, Integer>> entry : this.powerLevels.entrySet()) {
            this.cleanEntries((World)world, entry.getKey());
        }
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        this.highestPower.clear();
        this.powerLevels.clear();
        int errors = 0;
        int suberrors = 0;
        NBTTagList mainList = nbttagcompound.func_150295_c("MirrorsRedstoneData", 10);
        int count = mainList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound compound = mainList.func_150305_b(i);
            int[] arr = compound.func_74759_k("mirrorPos");
            if (arr.length != 3) {
                ++errors;
                continue;
            }
            NBTTagList sublist = compound.func_150295_c("links", 10);
            int subcount = sublist.func_74745_c();
            if (subcount <= 0) continue;
            BlockCoord mirrorPos = new BlockCoord(arr);
            this.highestPower.put(mirrorPos, -1);
            HashMap<BlockCoord, Integer> submap = new HashMap<BlockCoord, Integer>();
            this.powerLevels.put(mirrorPos, submap);
            for (int j = 0; j < subcount; ++j) {
                NBTTagCompound tag = sublist.func_150305_b(j);
                int[] arr2 = tag.func_74759_k("pos");
                if (arr2.length != 3) {
                    ++suberrors;
                    continue;
                }
                int strength = tag.func_74762_e("strength");
                submap.put(new BlockCoord(arr2), strength);
            }
        }
        this.dimensionID = nbttagcompound.func_74762_e("MirrorsRedstoneDimension");
        if (errors > 0 || suberrors > 0) {
            FMLLog.warning((String)("[Automagy] RedstoneMirrorNetwork: Malformed save data detected. Failed to load " + errors + " redstone strength entries and " + suberrors + " sub-entries."), (Object[])new Object[0]);
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        NBTTagList mainList = new NBTTagList();
        for (Map.Entry<BlockCoord, HashMap<BlockCoord, Integer>> entry : this.powerLevels.entrySet()) {
            BlockCoord mirrorPos = entry.getKey();
            HashMap<BlockCoord, Integer> submap = entry.getValue();
            if (submap.size() <= 0) continue;
            NBTTagCompound compound = new NBTTagCompound();
            mainList.func_74742_a((NBTBase)compound);
            compound.func_74783_a("mirrorPos", new int[]{mirrorPos.x, mirrorPos.y, mirrorPos.z});
            NBTTagList sublist = new NBTTagList();
            compound.func_74782_a("links", (NBTBase)sublist);
            for (Map.Entry<BlockCoord, Integer> subentry : submap.entrySet()) {
                Integer strength = subentry.getValue();
                if (strength == null || strength <= 0) continue;
                BlockCoord pos = subentry.getKey();
                NBTTagCompound tag = new NBTTagCompound();
                sublist.func_74742_a((NBTBase)tag);
                tag.func_74783_a("pos", new int[]{pos.x, pos.y, pos.z});
                tag.func_74768_a("strength", strength.intValue());
            }
        }
        nbttagcompound.func_74782_a("MirrorsRedstoneData", (NBTBase)mainList);
        nbttagcompound.func_74768_a("MirrorsRedstoneDimension", this.dimensionID);
    }

    public static RedstoneMirrorNetwork getData(int dimensionID) {
        WorldServer worldSave = MinecraftServer.func_71276_C().func_71218_a(dimensionID);
        RedstoneMirrorNetwork data = (RedstoneMirrorNetwork)worldSave.func_72943_a(RedstoneMirrorNetwork.class, "AutomagyUniversalRedstone");
        if (data == null) {
            data = new RedstoneMirrorNetwork("AutomagyUniversalRedstone");
            data.dimensionID = dimensionID;
            worldSave.func_72823_a("AutomagyUniversalRedstone", (WorldSavedData)data);
        }
        return data;
    }

    public static RedstoneMirrorNetwork getData(World world) {
        return RedstoneMirrorNetwork.getData(world.field_73011_w.field_76574_g);
    }
}

