/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChickenChunks;
import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.IChickenChunkLoader;
import codechicken.chunkloader.TileChunkLoaderRenderer;
import codechicken.lib.vec.BlockCoord;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileChunkLoaderBase
extends TileEntity
implements IChickenChunkLoader {
    public String owner;
    protected boolean loaded = false;
    protected boolean powered = false;
    public TileChunkLoaderRenderer.RenderInfo renderInfo;
    public boolean active = false;

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("powered", this.powered);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("owner")) {
            this.owner = tag.func_74779_i("owner");
        }
        if (tag.func_74764_b("powered")) {
            this.powered = tag.func_74767_n("powered");
        }
        this.loaded = true;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && this.loaded && !this.powered) {
            this.activate();
        }
        if (this.field_145850_b.field_72995_K) {
            this.renderInfo = new TileChunkLoaderRenderer.RenderInfo();
        }
    }

    public boolean isPowered() {
        return TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 0) || TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, 1) || TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, 2) || TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, 3) || TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, 4) || TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, 5);
    }

    public static boolean isPoweringTo(World world, int x, int y, int z, int side) {
        return world.func_147439_a(x, y, z).func_149709_b((IBlockAccess)world, x, y, z, side) > 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.deactivate();
        }
    }

    public void destroyBlock() {
        ChickenChunks.blockChunkLoader.func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ChunkCoordIntPair getChunkPosition() {
        return new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
    }

    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        if (entityliving instanceof EntityPlayer) {
            this.owner = entityliving.func_70005_c_();
        }
        if (this.owner.equals("")) {
            this.owner = null;
        }
        this.activate();
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Object getMod() {
        return ChickenChunks.instance;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockCoord getPosition() {
        return new BlockCoord((TileEntity)this);
    }

    @Override
    public void deactivate() {
        this.loaded = true;
        this.active = false;
        ChunkLoaderManager.remChunkLoader(this);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void activate() {
        this.loaded = true;
        this.active = true;
        ChunkLoaderManager.addChunkLoader(this);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean nowPowered = this.isPowered();
            if (this.powered != nowPowered) {
                this.powered = nowPowered;
                if (this.powered) {
                    this.deactivate();
                } else {
                    this.activate();
                }
            }
        } else {
            this.renderInfo.update(this);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

