/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.endercollector;

import com.rwtema.extrautils.EventHandlerEntityItemStealer;
import com.rwtema.extrautils.tileentity.endercollector.TileEnderCollector;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class CollectorHandler {
    public static final WeakHashMap<World, WeakHashMap<TileEnderCollector, Object>> map = new WeakHashMap();
    public static CollectorHandler INSTANCE = new CollectorHandler();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (map.isEmpty()) {
            return;
        }
        WeakHashMap<TileEnderCollector, Object> map = CollectorHandler.map.get(event.entity.field_70170_p);
        if (map == null || map.isEmpty()) {
            return;
        }
        Entity entity = event.entity;
        if (EventHandlerEntityItemStealer.isEntityItem(entity.getClass())) {
            ItemStack stack = entity.func_70096_w().func_82710_f(10);
            if (stack == null) {
                return;
            }
            for (TileEnderCollector tileEnderCollector : map.keySet()) {
                if (!tileEnderCollector.inRange(entity)) continue;
                tileEnderCollector.grabEntity((EntityItem)entity);
            }
            if (entity.field_70128_L) {
                event.setCanceled(true);
            }
        }
    }

    public static void register(TileEnderCollector tile) {
        CollectorHandler.getWorldMap(tile).put(tile, null);
    }

    public static void unregister(TileEnderCollector tile) {
        CollectorHandler.getWorldMap(tile).remove((Object)tile);
    }

    public static WeakHashMap<TileEnderCollector, Object> getWorldMap(TileEnderCollector tile) {
        WeakHashMap<TileEnderCollector, Object> worldMap = map.get(tile.func_145831_w());
        if (worldMap == null) {
            worldMap = new WeakHashMap();
            map.put(tile.func_145831_w(), worldMap);
        }
        return worldMap;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }
}

