/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotInaccessible;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumicenergistics.container.ContainerWithPlayerInventory;
import thaumicenergistics.container.slot.SlotRestrictive;
import thaumicenergistics.integration.tc.ArcaneCraftingPattern;
import thaumicenergistics.integration.tc.ArcaneRecipeHelper;
import thaumicenergistics.inventory.HandlerKnowledgeCore;
import thaumicenergistics.items.ItemKnowledgeCore;
import thaumicenergistics.network.packet.client.PacketClientKnowledgeInscriber;
import thaumicenergistics.tileentities.TileKnowledgeInscriber;
import thaumicenergistics.util.EffectiveSide;

public class ContainerKnowledgeInscriber
extends ContainerWithPlayerInventory {
    private static final int PLAYER_INV_POSITION_Y = 162;
    private static final int HOTBAR_INV_POSITION_Y = 220;
    private static final int KCORE_SLOT_X = 186;
    private static final int KCORE_SLOT_Y = 8;
    private static final int PATTERN_SLOT_X = 26;
    private static final int PATTERN_SLOT_Y = 18;
    private static final int PATTERN_ROWS = 3;
    private static final int PATTERN_COLS = 7;
    private static final int PATTERN_SLOT_SPACING = 18;
    private static final int CRAFTING_SLOT_X = 26;
    private static final int CRAFTING_SLOT_Y = 90;
    private static final int CRAFTING_ROWS = 3;
    private static final int CRAFTING_COLS = 3;
    private static final int CRAFTING_SLOT_SPACING = 18;
    private static final int MAXIMUM_PATTERNS = 21;
    private SlotRestrictive kCoreSlot;
    private SlotInaccessible[] patternSlots = new SlotInaccessible[21];
    private SlotFakeCraftingMatrix[] craftingSlots = new SlotFakeCraftingMatrix[9];
    private SlotFake resultSlot;
    private int patternSlot_first;
    private int patternSlot_last;
    private int craftingSlot_first;
    private int craftingSlot_last;
    private HandlerKnowledgeCore kCoreHandler;
    private EntityPlayer player;
    private IArcaneRecipe activeRecipe = null;
    private boolean hadCoreLastCheck = false;
    private TileKnowledgeInscriber inscriber;

    public ContainerKnowledgeInscriber(EntityPlayer player, World world, int x, int y, int z) {
        this.player = player;
        this.bindPlayerInventory((IInventory)player.field_71071_by, 162, 220);
        this.inscriber = (TileKnowledgeInscriber)world.func_147438_o(x, y, z);
        IInventory inscriberInventory = this.inscriber.getInventory();
        this.kCoreSlot = new SlotRestrictive(inscriberInventory, 0, 186, 8);
        this.func_75146_a(this.kCoreSlot);
        this.initPatternSlots(inscriberInventory);
        this.initCraftingSlots(inscriberInventory);
        this.resultSlot = new SlotFake(inscriberInventory, 31, 116, 108);
        this.func_75146_a((Slot)this.resultSlot);
        if (EffectiveSide.isServerSide()) {
            if (this.kCoreSlot.func_75216_d()) {
                this.hadCoreLastCheck = true;
                this.kCoreHandler = new HandlerKnowledgeCore(this.kCoreSlot.func_75211_c());
            }
            this.updatePatternSlots();
            this.func_75130_a(inscriberInventory);
        }
    }

    private CoreSaveState getSaveState() {
        CoreSaveState saveState;
        if (this.kCoreHandler == null) {
            saveState = CoreSaveState.Disabled_MissingCore;
        } else if (this.activeRecipe == null) {
            saveState = CoreSaveState.Disabled_InvalidRecipe;
        } else {
            ItemStack recipeOutput = ArcaneRecipeHelper.instance.getRecipeOutput(this.inscriber.getInventory(), 22, 9, this.activeRecipe);
            if (recipeOutput == null) {
                saveState = CoreSaveState.Disabled_InvalidRecipe;
            } else {
                boolean isNew;
                boolean bl = isNew = !this.kCoreHandler.hasPatternFor(recipeOutput);
                saveState = isNew ? (this.kCoreHandler.hasRoomToStorePattern() ? CoreSaveState.Enabled_Save : CoreSaveState.Disabled_CoreFull) : CoreSaveState.Enabled_Delete;
            }
        }
        return saveState;
    }

    private void initCraftingSlots(IInventory inscriberInventory) {
        int slotIndex = 22;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = row * 3 + column;
                int posX = 26 + 18 * column;
                int posY = 90 + 18 * row;
                this.craftingSlots[index] = new SlotFakeCraftingMatrix(inscriberInventory, slotIndex++, posX, posY);
                this.func_75146_a((Slot)this.craftingSlots[index]);
            }
        }
        this.craftingSlot_first = this.craftingSlots[0].field_75222_d;
        this.craftingSlot_last = this.craftingSlots[this.craftingSlots.length - 1].field_75222_d;
    }

    private void initPatternSlots(IInventory inscriberInventory) {
        int slotIndex = 1;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 7; ++column) {
                int index = row * 7 + column;
                int posX = 26 + 18 * column;
                int posY = 18 + 18 * row;
                this.patternSlots[index] = new SlotInaccessible(inscriberInventory, slotIndex++, posX, posY);
                this.func_75146_a((Slot)this.patternSlots[index]);
            }
        }
        this.patternSlot_first = this.patternSlots[0].field_75222_d;
        this.patternSlot_last = this.patternSlots[this.patternSlots.length - 1].field_75222_d;
    }

    private void updatePatternSlots() {
        Iterator<ItemStack> iterator = null;
        if (this.kCoreHandler != null) {
            ArrayList<ItemStack> storedResults = this.kCoreHandler.getStoredOutputs();
            iterator = storedResults.iterator();
        }
        for (SlotInaccessible patternSlot : this.patternSlots) {
            if (iterator != null && iterator.hasNext()) {
                patternSlot.func_75215_d(iterator.next());
            } else {
                patternSlot.func_75215_d(null);
            }
            for (int cIndex = 0; cIndex < this.field_75149_d.size(); ++cIndex) {
                ((ICrafting)this.field_75149_d.get(cIndex)).func_71111_a((Container)this, patternSlot.field_75222_d, patternSlot.func_75211_c());
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (EffectiveSide.isClientSide()) {
            return;
        }
        boolean hasCore = this.kCoreSlot.func_75216_d();
        if (hasCore != this.hadCoreLastCheck) {
            this.kCoreHandler = hasCore ? new HandlerKnowledgeCore(this.kCoreSlot.func_75211_c()) : null;
            this.updatePatternSlots();
            this.onClientRequestFullUpdate(this.player);
            this.inscriber.func_70296_d();
        }
        this.hadCoreLastCheck = hasCore;
    }

    public void onClientRequestFullUpdate(EntityPlayer player) {
        new PacketClientKnowledgeInscriber().createSendSaveState(player, this.getSaveState()).sendPacketToPlayer();
    }

    public void onClientRequestSaveOrDelete(EntityPlayer player) {
        ArcaneCraftingPattern pattern;
        CoreSaveState saveState = this.getSaveState();
        if (saveState == CoreSaveState.Enabled_Save) {
            int gridSize = 9;
            ItemStack[] inputs = new ItemStack[gridSize];
            for (int index = 0; index < gridSize; ++index) {
                inputs[index] = this.craftingSlots[index].func_75211_c();
            }
            AspectList recipeAspects = ArcaneRecipeHelper.instance.getRecipeAspectCost(this.inscriber.getInventory(), 22, 9, this.activeRecipe);
            ArcaneCraftingPattern pattern2 = new ArcaneCraftingPattern(this.kCoreSlot.func_75211_c(), recipeAspects, this.resultSlot.func_75211_c(), inputs);
            this.kCoreHandler.addPattern(pattern2);
            this.updatePatternSlots();
            this.onClientRequestFullUpdate(player);
            this.inscriber.func_70296_d();
        } else if (saveState == CoreSaveState.Enabled_Delete && (pattern = this.kCoreHandler.getPatternForItem(this.resultSlot.func_75211_c())) != null) {
            this.kCoreHandler.removePattern(pattern);
            this.updatePatternSlots();
            this.onClientRequestFullUpdate(player);
            this.inscriber.func_70296_d();
        }
    }

    public void func_75130_a(IInventory inv) {
        this.activeRecipe = ArcaneRecipeHelper.instance.findMatchingArcaneResult(inv, 22, 9, this.player);
        ItemStack craftResult = null;
        if (this.activeRecipe != null) {
            craftResult = ArcaneRecipeHelper.instance.getRecipeOutput(inv, 22, 9, this.activeRecipe);
        }
        this.resultSlot.func_75215_d(craftResult);
        if (EffectiveSide.isServerSide()) {
            this.onClientRequestFullUpdate(this.player);
        }
        this.func_75142_b();
    }

    public ItemStack func_75144_a(int slotID, int buttonPressed, int flag, EntityPlayer player) {
        if (EffectiveSide.isServerSide()) {
            try {
                Slot clickedSlot = this.func_75139_a(slotID);
                ItemStack draggingStack = player.field_71071_by.func_70445_o();
                if (clickedSlot.field_75222_d >= this.craftingSlot_first && clickedSlot.field_75222_d <= this.craftingSlot_last) {
                    if (draggingStack != null) {
                        ItemStack copiedStack = draggingStack.func_77946_l();
                        copiedStack.field_77994_a = 1;
                        clickedSlot.func_75215_d(copiedStack);
                    } else {
                        clickedSlot.func_75215_d(null);
                    }
                    this.func_75130_a(clickedSlot.field_75224_c);
                    return draggingStack;
                }
                if (clickedSlot.field_75222_d >= this.patternSlot_first && clickedSlot.field_75222_d <= this.patternSlot_last) {
                    if (clickedSlot.func_75216_d()) {
                        ArcaneCraftingPattern pattern = this.kCoreHandler.getPatternForItem(clickedSlot.func_75211_c());
                        for (int index = 0; index < this.craftingSlots.length; ++index) {
                            IAEItemStack ingStack = pattern.ingredients[index];
                            if (ingStack != null) {
                                this.craftingSlots[index].func_75215_d(ingStack.getItemStack());
                                continue;
                            }
                            this.craftingSlots[index].func_75215_d(null);
                        }
                        this.func_75130_a(clickedSlot.field_75224_c);
                    }
                    return draggingStack;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return super.func_75144_a(slotID, buttonPressed, flag, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (EffectiveSide.isClientSide()) {
            return null;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            boolean didMerge = false;
            ItemStack slotStack = slot.func_75211_c();
            if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                if (slotStack.func_77973_b() instanceof ItemKnowledgeCore) {
                    didMerge = this.func_75135_a(slotStack, this.kCoreSlot.field_75222_d, this.kCoreSlot.field_75222_d + 1, false);
                }
                if (!didMerge) {
                    didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            } else if (this.kCoreSlot.field_75222_d == slotNumber && !(didMerge = this.mergeSlotWithHotbarInventory(slotStack))) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            }
            if (didMerge) {
                if (slotStack == null || slotStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
                this.func_75142_b();
            }
        }
        return null;
    }

    public static enum CoreSaveState {
        Disabled_InvalidRecipe,
        Disabled_CoreFull,
        Disabled_MissingCore,
        Enabled_Save,
        Enabled_Delete;

    }
}

