/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mod.lucky.util.LuckyFunction;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class ItemLuckyBlock
extends ItemBlock {
    public ItemLuckyBlock(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack itemStack) {
        int luckLevel = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        if (luckLevel == 0 && (drops == null || drops.length == 0)) {
            return 64;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        int luck = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        list.add(StatCollector.func_74838_a((String)"item.luckyBlock.luck") + ": " + (luck == 0 ? EnumChatFormatting.GOLD : (luck < 0 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN + "+")) + String.valueOf(luck));
        if (drops != null && drops.length != 0) {
            list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.luckyBlock.customDrop"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        NBTTagCompound luckyTag = new NBTTagCompound();
        luckyTag.func_74768_a("Luck", 80);
        NBTTagCompound unluckyTag = new NBTTagCompound();
        unluckyTag.func_74768_a("Luck", -80);
        ItemStack normalItemStack = new ItemStack(item, 1, 0);
        list.add(normalItemStack);
        ItemStack luckyItemStack = new ItemStack(item, 1, 0);
        luckyItemStack.func_77982_d(luckyTag);
        luckyItemStack.func_151001_c("Very Lucky Block");
        list.add(luckyItemStack);
        ItemStack unluckyItemStack = new ItemStack(item, 1, 0);
        unluckyItemStack.func_77982_d(unluckyTag);
        unluckyItemStack.func_151001_c("Unlucky Block");
        list.add(unluckyItemStack);
    }

    public static int getLuck(ItemStack itemStack) {
        try {
            return itemStack.func_77978_p().func_74762_e("Luck");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static String[] getDrops(ItemStack itemStack) {
        try {
            return LuckyFunction.getArrayFromNBTTagList((NBTTagList)itemStack.func_77978_p().func_74781_a("Drops"));
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

