/*
 * Decompiled with CFR 0.152.
 */
package me.exz.wailanbt.handler;

import com.google.gson.JsonElement;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import mcp.mobius.waila.api.SpecialChars;
import me.exz.wailanbt.configuration.config;
import me.exz.wailanbt.util.NBTHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.StringUtils;

public class NBTHandler {
    public static ScriptEngineManager manager;
    public static ScriptEngine engine;
    public static HashSet<String> scriptSet;
    static byte flag;
    static String id;

    static List<String> getTipsFromNBT(NBTTagCompound n, String heldItemName) {
        ArrayList<String> tips = new ArrayList<String>();
        Set holdItemA = config.configJson.entrySet();
        for (Map.Entry holdItem : holdItemA) {
            Pattern pattern = Pattern.compile((String)holdItem.getKey());
            Matcher matcher = pattern.matcher(heldItemName);
            if (!matcher.matches() && flag != 2) continue;
            Set teIDA = ((JsonElement)holdItem.getValue()).getAsJsonObject().entrySet();
            for (Map.Entry teID : teIDA) {
                tips.addAll(NBTHandler.getTipsFromNBTWithHeldItem(n, (String)teID.getKey(), (JsonElement)teID.getValue()));
            }
        }
        return tips;
    }

    private static List<String> getTipsFromNBTWithHeldItem(NBTTagCompound n, String teID, JsonElement teEntry) {
        ArrayList<String> tips = new ArrayList<String>();
        String teIDReal = id;
        Pattern pattern = Pattern.compile(teID);
        Matcher matcher = pattern.matcher(teIDReal);
        if (matcher.matches()) {
            Set pathA = teEntry.getAsJsonObject().entrySet();
            for (Map.Entry path : pathA) {
                String tip = NBTHandler.getTipFromNBTWithPath(n, (String)path.getKey(), ((JsonElement)path.getValue()).getAsString());
                if (tip.equals("__ERROR__")) continue;
                tips.add(tip);
            }
        }
        return tips;
    }

    private static String getTipFromNBTWithPath(NBTTagCompound n, String path, String displayName) {
        ArrayList<String> pathDeep = new ArrayList<String>(Arrays.asList(path.split(">>>")));
        String tip = NBTHandler.getTipFromPathDeep((NBTBase)n, pathDeep, displayName.isEmpty() ? path : displayName);
        if (!tip.equals("__ERROR__")) {
            return tip;
        }
        return "__ERROR__";
    }

    private static String getTipFromPathDeep(NBTBase n, List<String> pathDeep, String displayName) {
        if (pathDeep.size() == 0) {
            String tipValue = NBTHelper.NBTToString(n);
            if (tipValue.equals("__ERROR__")) {
                return "__ERROR__";
            }
            return NBTHandler.getTipFormatted(displayName, tipValue);
        }
        String subID = pathDeep.get(0);
        pathDeep.remove(0);
        NBTBase subTag = null;
        try {
            block1 : switch (n.func_74732_a()) {
                case 10: {
                    subTag = ((NBTTagCompound)n).func_74781_a(subID);
                    break;
                }
                case 9: {
                    NBTTagList tag = (NBTTagList)n;
                    Integer subTagType = tag.func_150303_d();
                    Integer subTagID = Integer.valueOf(subID);
                    switch (subTagType) {
                        case 10: {
                            subTag = tag.func_150305_b(subTagID.intValue());
                            break block1;
                        }
                        case 11: {
                            subTag = new NBTTagIntArray(tag.func_150306_c(subTagID.intValue()));
                            break block1;
                        }
                        case 6: {
                            subTag = new NBTTagDouble(tag.func_150309_d(subTagID.intValue()));
                            break block1;
                        }
                        case 5: {
                            subTag = new NBTTagFloat(tag.func_150308_e(subTagID.intValue()));
                            break block1;
                        }
                        case 8: {
                            String tipValue = tag.func_150307_f(subTagID.intValue());
                            return NBTHandler.getTipFormatted(displayName, StringUtils.substring((String)tipValue, (int)1, (int)-1));
                        }
                    }
                    return "__ERROR__";
                }
            }
            return NBTHandler.getTipFromPathDeep(subTag, pathDeep, displayName);
        }
        catch (Exception e) {
            return "__ERROR__";
        }
    }

    private static String getTipFormatted(String displayName, String tipValue) {
        if (displayName.startsWith("function p(v){")) {
            try {
                String hash = "S" + NBTHandler.MD5(displayName);
                if (!scriptSet.contains(hash)) {
                    scriptSet.add(hash);
                    String script = "function " + hash + displayName.substring(10);
                    engine.eval(script);
                }
                Invocable invoke = (Invocable)((Object)engine);
                return String.valueOf(invoke.invokeFunction(hash, tipValue));
            }
            catch (Exception e) {
                e.printStackTrace();
                return "__ERROR__";
            }
        }
        if (displayName.contains("%")) {
            try {
                return String.format(displayName, Double.valueOf(tipValue));
            }
            catch (Exception e) {
                try {
                    return String.format(displayName, String.valueOf(tipValue));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (flag == 2) {
            return String.format("%s : %s", displayName, tipValue);
        }
        return String.format("%s" + SpecialChars.TAB + SpecialChars.ALIGNRIGHT + SpecialChars.WHITE + "%s", displayName, tipValue);
    }

    private static String MD5(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(string.getBytes());
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        id = "";
    }
}

