/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.util;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import tterrag.core.common.util.BlockCoord;

public final class TTEntityUtils {
    private static final Random rand = new Random();

    public static void setEntityVelocity(Entity entity, double velX, double velY, double velZ) {
        entity.field_70159_w = velX;
        entity.field_70181_x = velY;
        entity.field_70179_y = velZ;
    }

    public static EntityFireworkRocket getRandomFirework(World world) {
        return TTEntityUtils.getRandomFirework(world, new BlockCoord(0, 0, 0));
    }

    public static EntityFireworkRocket getRandomFirework(World world, BlockCoord pos) {
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.field_77990_d = new NBTTagCompound();
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[rand.nextInt(16)];
        }
        expl.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        expl.func_74774_a("Type", type);
        NBTTagList explosions = new NBTTagList();
        explosions.func_74742_a((NBTBase)expl);
        NBTTagCompound fireworkTag = new NBTTagCompound();
        fireworkTag.func_74782_a("Explosions", (NBTBase)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.field_77990_d.func_74782_a("Fireworks", (NBTBase)fireworkTag);
        EntityFireworkRocket e = new EntityFireworkRocket(world, (double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, firework);
        return e;
    }

    public static void spawnFirework(BlockCoord block, int dimID) {
        TTEntityUtils.spawnFirework(block, dimID, 0);
    }

    public static void spawnFirework(BlockCoord block, int dimID, int range) {
        WorldServer world = DimensionManager.getWorld((int)dimID);
        BlockCoord pos = new BlockCoord(0, 0, 0);
        pos.setPosition(block.x, block.y, block.z);
        if (range > 0) {
            pos.setPosition(TTEntityUtils.moveRandomly(block.x, range), block.y, TTEntityUtils.moveRandomly(block.z, range));
            int tries = -1;
            while (!world.func_147437_c(pos.x, pos.y, pos.z) && !world.func_147439_a(pos.x, pos.y, pos.z).isReplaceable((IBlockAccess)world, pos.x, pos.y, pos.z)) {
                if (++tries <= 100) continue;
                return;
            }
        }
        world.func_72838_d((Entity)TTEntityUtils.getRandomFirework((World)world, pos));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + rand.nextDouble() * range - range / 2.0;
    }

    private TTEntityUtils() {
    }
}

