/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import openmods.utils.ItemUtils;
import openmods.utils.MiscUtils;
import openperipheral.addons.OpenPeripheralAddons;
import openperipheral.addons.api.ITerminalItem;
import openperipheral.addons.api.TerminalRegisterEvent;
import openperipheral.addons.glasses.TerminalUtils;

public class ItemGlasses
extends ItemArmor
implements ITerminalItem {
    private static final String OPENP_TAG = "openp";

    public ItemGlasses() {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, 0);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(OpenPeripheralAddons.tabOpenPeripheralAddons);
        this.func_77655_b("openperipheral.glasses");
    }

    private static Long extractGuid(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        if (!tag.func_74764_b(OPENP_TAG)) {
            return null;
        }
        NBTTagCompound openp = tag.func_74775_l(OPENP_TAG);
        return TerminalUtils.extractGuid(openp);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        Long guid = ItemGlasses.extractGuid(itemStack);
        if (guid != null) {
            list.add(StatCollector.func_74837_a((String)"openperipheral.misc.key", (Object[])new Object[]{TerminalUtils.formatTerminalId(guid)}));
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        switch (MiscUtils.getHoliday()) {
            case 1: {
                return "openperipheraladdons:textures/models/glasses_valentines.png";
            }
            case 2: {
                return "openperipheraladdons:textures/models/glasses_halloween.png";
            }
            case 3: {
                return "openperipheraladdons:textures/models/glasses_christmas.png";
            }
        }
        return "openperipheraladdons:textures/models/glasses.png";
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("openperipheraladdons:glasses");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        Long guid;
        if (player instanceof EntityPlayerMP && (guid = ItemGlasses.extractGuid(itemStack)) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new TerminalRegisterEvent((EntityPlayerMP)player, guid));
        }
    }

    @Override
    public Long getTerminalGuid(ItemStack stack) {
        return ItemGlasses.extractGuid(stack);
    }

    @Override
    public void bindToTerminal(ItemStack stack, long guid) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        NBTTagCompound openPTag = (NBTTagCompound)tag.func_74781_a(OPENP_TAG);
        if (openPTag == null) {
            openPTag = new NBTTagCompound();
            tag.func_74782_a(OPENP_TAG, (NBTBase)openPTag);
        }
        openPTag.func_74772_a("guid", guid);
    }
}

