/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.harvestlevels;

import iguanaman.iguanatweakstconstruct.harvestlevels.HarvestLevelTweaks;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import iguanaman.iguanatweakstconstruct.util.ModSupportHelper;
import java.util.HashSet;
import java.util.Iterator;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.tools.TinkerTools;

public final class TinkerMaterialTweaks {
    private static float durabilityMod;
    private static float speedMod;

    private TinkerMaterialTweaks() {
    }

    public static void modifyToolMaterials() {
        Log.debug("Modifying TConstruct materials");
        durabilityMod = (float)Config.durabilityPercentage / 100.0f;
        speedMod = (float)Config.miningSpeedPercentage / 100.0f;
        HashSet copyOfMaterials = new HashSet(TConstructRegistry.toolMaterials.values());
        for (ToolMaterial material : copyOfMaterials) {
            int newHlvl = HarvestLevelTweaks.getUpdatedHarvestLevel(material.harvestLevel());
            TinkerMaterialTweaks.updateMaterial(newHlvl, material.name(), material.durability(), material.toolSpeed(), material.attack(), material.handleDurability());
        }
        TinkerMaterialTweaks.modifyTcon();
        if (ModSupportHelper.ExtraTiC) {
            TinkerMaterialTweaks.modifyExtraTiC();
        }
        Log.debug("Finished modifying TConstruct materials");
    }

    private static void modifyTcon() {
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "Paper", 21, 100, 1, 0.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "Wood", 50, 150, 1, 1.0f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "Stone", 100, 150, 1, 0.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "Cactus", 110, 500, 3, 1.0f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "Netherrack", 123, 456, 1, 1.2f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "BlueSlime", 1200, 150, 1, 1.5f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "Slime", 500, 100, 1, 2.0f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._1_flint, "Flint", 151, 400, 2, 0.5f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._1_flint, "Bone", 201, 300, 2, 1.08f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._2_copper, "Copper", 180, 500, 2, 1.1f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Iron", 250, 600, 3, 1.2f);
        if (TinkerTools.thaumcraftAvailable) {
            TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Thaumium", 200, 650, 3, 1.18f);
        }
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Bronze", 380, 650, 3, 1.25f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._5_diamond, "Steel", 400, 700, 3, 1.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._5_diamond, "PigIron", 667, 780, 3, 1.35f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Obsidian", 89, 650, 2, 0.8f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Alumite", 550, 790, 4, 1.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._7_ardite, "Ardite", 606, 800, 4, 2.1f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._8_cobalt, "Cobalt", 800, 1100, 4, 1.75f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._9_manyullym, "Manyullyn", 1200, 900, 5, 2.5f);
    }

    private static void modifyExtraTiC() {
        if (ModSupportHelper.Metallurgy) {
            TinkerMaterialTweaks.modifyMetallurgyBasePrecious();
            TinkerMaterialTweaks.modifyMetallurgyFantasy();
            TinkerMaterialTweaks.modifyMetallurgyNether();
            TinkerMaterialTweaks.modifyMetallurgyEnd();
        }
        if (ModSupportHelper.Natura) {
            TinkerMaterialTweaks.modifyNatura();
        }
        if (ModSupportHelper.Mekanism) {
            TinkerMaterialTweaks.modifyMekanism();
        }
        if (ModSupportHelper.BiomesOPlenty) {
            TinkerMaterialTweaks.updateMaterial(HarvestLevels._5_diamond, "Amethyst", 1548, 800, 5, 1.1f);
        }
        if (ModSupportHelper.AppliedEnergistics2) {
            TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Certus Quartz", 199, 800, 3, 0.8f);
        }
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Nether Quartz", 101, 550, 3, 0.7f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._7_ardite, "Fairy", 250, 1050, 5, 0.5f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._8_cobalt, "Pokefennium", 1000, 850, 2, 3.0f);
    }

    private static void modifyMetallurgyBasePrecious() {
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Hepatizon", 225, 750, 3, 0.8f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Damascus Steel", 515, 500, 4, 0.9f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Angmallen", 300, 600, 3, 1.35f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._2_copper, "Brass", 15, 750, 2, 0.2f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Silver", 25, 850, 2, 0.2f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Electrum", 100, 950, 2, 0.75f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Platinum", 100, 1300, 2, 0.75f);
    }

    private static void modifyMetallurgyFantasy() {
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._0_stone, "Prometheum", 100, 300, 1, 0.7f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._1_flint, "Deep Iron", 250, 450, 2, 0.8f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._2_copper, "Black Steel", 300, 550, 2, 0.9f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Oureclase", 330, 700, 3, 1.0f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Astral Silver", 35, 900, 2, 0.35f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._5_diamond, "Carmot", 150, 800, 2, 0.4f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Mithril", 700, 720, 3, 1.1f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Quicksilver", 600, 880, 4, 1.2f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._7_ardite, "Haderoth", 810, 800, 4, 1.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._8_cobalt, "Orichalcum", 1010, 900, 4, 1.5f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._8_cobalt, "Celenegil", 600, 1400, 3, 0.7f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._9_manyullym, "Adamantine", 1550, 1000, 5, 2.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._9_manyullym, "Atlarus", 1750, 1200, 5, 2.5f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._9_manyullym, "Tartarite", 2000, 1500, 6, 3.33f);
    }

    private static void modifyMetallurgyNether() {
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Ignatius", 200, 400, 3, 0.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Shadow Iron", 300, 400, 3, 1.2f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Shadow Steel", 400, 600, 4, 1.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._5_diamond, "Midasium", 111, 1111, 4, 1.1f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._5_diamond, "Vyroxeres", 300, 700, 3, 0.8f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Ceruclase", 500, 707, 4, 1.4f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._7_ardite, "Inolashite", 900, 800, 3, 0.81f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._7_ardite, "Kalendrite", 1000, 500, 4, 1.1f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._8_cobalt, "Amordrine", 900, 1400, 3, 1.0f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._8_cobalt, "Vulcanite", 1500, 1000, 4, 0.7f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._8_cobalt, "Sanguinite", 150, 200, 6, 0.5f);
    }

    private static void modifyMetallurgyEnd() {
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._5_diamond, "Eximite", 1000, 800, 4, 1.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Desichalkos", 1800, 1000, 5, 2.75f);
    }

    private static void modifyNatura() {
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._1_flint, "Ghostwood", 31, 300, 1, 2.0f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._2_copper, "Darkwood", 131, 400, 1, 1.5f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._3_iron, "Fusewood", 250, 600, 2, 1.66f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._4_bronze, "Bloodwood", 350, 700, 3, 1.84f);
    }

    private static void modifyMekanism() {
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Osmium", 500, 1000, 4, 1.3f);
        TinkerMaterialTweaks.updateMaterial(HarvestLevels._6_obsidian, "Refined Glowstone", 300, 1400, 5, 1.75f);
    }

    private static void updateMaterial(int harvestLevel, String matName, int newDurability, int newSpeed, int newAttack, float newHandleModifier) {
        ToolMaterial old = TConstructRegistry.getMaterial((String)matName);
        if (old == null) {
            Log.error(String.format("Could not find material for modification: %s", matName));
            return;
        }
        int durability = Math.round((float)newDurability * durabilityMod);
        int speed = Math.round((float)newSpeed * speedMod);
        ToolMaterial newMaterial = new ToolMaterial(old.materialName, harvestLevel, durability, speed, newAttack, newHandleModifier, old.reinforced(), old.shoddy(), old.style(), old.primaryColor());
        Integer id = TinkerMaterialTweaks.getMaterialID(old);
        if (id > -1) {
            TConstructRegistry.toolMaterials.remove(id);
            TConstructRegistry.toolMaterialStrings.remove(old.materialName);
            TConstructRegistry.addtoolMaterial((int)id, (ToolMaterial)newMaterial);
        } else {
            Log.error("Couldn't find ToolMaterial ID for " + old.name());
        }
    }

    private static Integer getMaterialID(ToolMaterial material) {
        Iterator i$ = TConstructRegistry.toolMaterials.keySet().iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            if (TConstructRegistry.toolMaterials.get(k) != material) continue;
            return k;
        }
        return -1;
    }
}

