/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import openmods.OpenMods;

public class WorldUtils {
    public static final IEntitySelector NON_PLAYER = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return !(entity instanceof EntityPlayer);
        }
    };

    public static <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<? extends T> cls, AxisAlignedBB aabb) {
        return world.func_72872_a(cls, aabb);
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<? extends T> cls, AxisAlignedBB aabb, IEntitySelector selector) {
        return world.func_82733_a(cls, aabb, selector);
    }

    public static List<Entity> getEntitiesWithinAABBExcluding(Entity excluding, World world, AxisAlignedBB aabb) {
        return world.func_72839_b(excluding, aabb);
    }

    public static List<Entity> getEntitiesWithinAABB(Entity excluding, World world, AxisAlignedBB aabb, IEntitySelector selector) {
        return world.func_94576_a(excluding, aabb, selector);
    }

    public static World getWorld(int dimensionId) {
        World result;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            result = OpenMods.proxy.getServerWorld(dimensionId);
        } else {
            result = OpenMods.proxy.getClientWorld();
            Preconditions.checkArgument((result.field_73011_w.field_76574_g == dimensionId ? 1 : 0) != 0, (String)"Invalid client dimension id %s", (Object[])new Object[]{dimensionId});
        }
        Preconditions.checkNotNull((Object)result, (String)"Invalid world dimension %s", (Object[])new Object[]{dimensionId});
        return result;
    }

    public static boolean isTileEntityValid(TileEntity te) {
        if (te.func_145837_r()) {
            return false;
        }
        World world = te.func_145831_w();
        return world != null ? world.func_72899_e(te.field_145851_c, te.field_145848_d, te.field_145849_e) : false;
    }
}

