/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync.drops;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import openmods.reflection.FieldAccess;
import openmods.sync.ISyncableObject;
import openmods.sync.drops.StoreOnDrop;
import openmods.utils.ItemUtils;

public class DropTagSerializer {
    private final Map<String, ISyncableObject> objects = Maps.newHashMap();

    public void addObject(String name, ISyncableObject object) {
        ISyncableObject prev = this.objects.put(name, object);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate on name %s, values = '%s' -> '%s'", (Object[])new Object[]{name, prev, object});
    }

    public void addFields(Object target) {
        for (Field field : target.getClass().getDeclaredFields()) {
            StoreOnDrop marker = field.getAnnotation(StoreOnDrop.class);
            if (marker == null) continue;
            Preconditions.checkArgument((boolean)ISyncableObject.class.isAssignableFrom(field.getType()), (String)"Field '%s' has SyncableDrop annotation, but it's ISyncableObject", (Object[])new Object[]{field});
            FieldAccess wrappedField = FieldAccess.create(field);
            ISyncableObject obj = (ISyncableObject)wrappedField.get(target);
            Preconditions.checkNotNull((Object)obj, (String)"Field '%s' contains null", (Object[])new Object[]{field});
            String suggestedName = field.getName();
            String name = Strings.isNullOrEmpty((String)marker.name()) ? suggestedName : marker.name();
            this.addObject(name, obj);
        }
    }

    public void write(NBTTagCompound tag) {
        for (Map.Entry<String, ISyncableObject> e : this.objects.entrySet()) {
            e.getValue().writeToNBT(tag, e.getKey());
        }
    }

    public void read(NBTTagCompound tag, boolean skipEmpty) {
        for (Map.Entry<String, ISyncableObject> e : this.objects.entrySet()) {
            String key = e.getKey();
            if (skipEmpty && !tag.func_74764_b(key)) continue;
            e.getValue().readFromNBT(tag, key);
        }
    }

    public ItemStack write(ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag(stack);
        this.write(tag);
        return stack;
    }

    public void read(ItemStack stack, boolean skipEmpty) {
        NBTTagCompound tag = ItemUtils.getItemTag(stack);
        this.read(tag, skipEmpty);
    }
}

