/*
 * Decompiled with CFR 0.152.
 */
package openmods.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.utils.BlockProperties;

public class EntityBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int OBJECT_BLOCK_NAME = 11;
    private static final int OBJECT_BLOCK_META = 12;
    private boolean hasGravity = false;
    private boolean shouldDrop = true;
    private boolean hasAirResistance = true;
    public static final ForgeDirection[] PLACE_DIRECTIONS = new ForgeDirection[]{ForgeDirection.UNKNOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.DOWN};
    public TileEntity tileEntity;

    public EntityBlock(World world) {
        super(world);
        this.func_70105_a(0.925f, 0.925f);
    }

    private void setHeight(float height) {
        this.field_70131_O = height;
        this.field_70129_M = 0.0f;
    }

    public static EntityBlock create(World world, int x, int y, int z) {
        return EntityBlock.create(world, x, y, z, EntityBlock.class);
    }

    public static EntityBlock create(World world, int x, int y, int z, Class<? extends EntityBlock> klazz) {
        TileEntity te;
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        EntityBlock entity = null;
        try {
            entity = klazz.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (entity == null) {
            return null;
        }
        entity.setBlockNameAndMeta(BlockProperties.getBlockName(block), meta);
        if (block instanceof BlockContainer && (te = world.func_147438_o(x, y, z)) != null) {
            entity.tileEntity = te;
            te.func_145843_s();
            world.func_147475_p(x, y, z);
        }
        world.func_147468_f(x, y, z);
        entity.func_70080_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
        return entity;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(11, (Object)BlockProperties.getBlockName(Blocks.field_150357_h));
        this.field_70180_af.func_75682_a(12, (Object)0);
    }

    public void setBlockNameAndMeta(String name, int meta) {
        this.field_70180_af.func_75692_b(11, (Object)name);
        this.field_70180_af.func_75692_b(12, (Object)meta);
    }

    public String getBlockName() {
        return this.field_70180_af.func_75681_e(11);
    }

    public Block getBlock() {
        return BlockProperties.getBlockByName(this.getBlockName());
    }

    public int getBlockMeta() {
        return this.field_70180_af.func_75679_c(12);
    }

    public void setShouldDrop(boolean bool) {
        this.shouldDrop = bool;
    }

    public void setHasAirResistance(boolean bool) {
        this.hasAirResistance = bool;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        String blockName = tag.func_74779_i("BlockName");
        Block block = BlockProperties.getBlockByName(blockName);
        if (block == null) {
            this.func_70106_y();
            return;
        }
        int blockMeta = tag.func_74762_e("BlockMeta");
        this.setBlockNameAndMeta(blockName, blockMeta);
        NBTBase teTag = tag.func_74781_a("TileEntity");
        if (teTag instanceof NBTTagCompound) {
            this.tileEntity = TileEntity.func_145827_c((NBTTagCompound)((NBTTagCompound)teTag));
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("BlockName", this.getBlockName());
        tag.func_74768_a("BlockMeta", this.getBlockMeta());
        if (this.tileEntity != null) {
            NBTTagCompound teTag = new NBTTagCompound();
            this.tileEntity.func_145841_b(teTag);
            tag.func_74782_a("TileEntity", (NBTBase)teTag);
        }
    }

    public void func_70071_h_() {
        if (this.field_70163_u < -500.0) {
            this.func_70106_y();
            return;
        }
        if (this.hasGravity) {
            this.field_70181_x -= (double)0.04f;
        }
        if (this.hasAirResistance) {
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70066_B();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        Block block = this.getBlock();
        if (block == null) {
            this.func_70106_y();
        } else {
            this.setHeight((float)block.func_149669_A());
        }
        if (this.shouldPlaceBlock()) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            if (!this.tryPlaceBlock(x, y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v))) {
                this.dropBlock();
            }
            this.func_70106_y();
        }
    }

    protected boolean shouldPlaceBlock() {
        return this.field_70122_E && this.shouldDrop;
    }

    private boolean tryPlaceBlock(int baseX, int baseY, int baseZ) {
        for (ForgeDirection dir : PLACE_DIRECTIONS) {
            int x = baseX + dir.offsetX;
            int y = baseY + dir.offsetY;
            int z = baseZ + dir.offsetZ;
            if (!this.field_70170_p.func_147437_c(x, y, z)) continue;
            this.field_70170_p.func_147465_d(x, y, z, this.getBlock(), this.getBlockMeta(), 3);
            if (this.tileEntity != null) {
                this.tileEntity.field_145851_c = x;
                this.tileEntity.field_145848_d = y;
                this.tileEntity.field_145849_e = z;
                this.tileEntity.func_145829_t();
                this.field_70170_p.func_147455_a(x, y, z, this.tileEntity);
            }
            return true;
        }
        return false;
    }

    private void dropBlock() {
        ItemStack item = new ItemStack(this.getBlock(), 1, this.getBlockMeta());
        this.func_70099_a(item, 0.1f);
        if (this.tileEntity instanceof IInventory) {
            IInventory inv = (IInventory)this.tileEntity;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is == null) continue;
                this.func_70099_a(is, 0.1f);
            }
        }
    }

    public void setHasGravity(boolean gravity) {
        this.hasGravity = gravity;
    }

    public boolean hasGravity() {
        return this.hasGravity;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    protected void func_70081_e(int i) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeBoolean(this.hasGravity);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.dropBlock();
        }
        this.func_70106_y();
        return false;
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.hasGravity = additionalData.readBoolean();
    }
}

