/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Env;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

@Asynchronous
public class LuaReflectionHelper {
    private static Map<String, Object> describe(Method method) {
        HashMap desc = Maps.newHashMap();
        ArrayList args = Lists.newArrayList();
        for (Class<?> arg : method.getParameterTypes()) {
            args.add(arg.toString());
        }
        desc.put("modifiers", Modifier.toString(method.getModifiers()));
        desc.put("from", method.getDeclaringClass().toString());
        desc.put("args", args);
        return desc;
    }

    private static Map<String, Map<String, Object>> describe(Method[] methods) {
        HashMap results = Maps.newHashMap();
        for (Method method : methods) {
            results.put(method.getName(), LuaReflectionHelper.describe(method));
        }
        return results;
    }

    @ScriptCallable(returnTypes={ReturnType.STRING})
    public String getClass(@Env(value="target") Object owner) {
        return owner.getClass().toString();
    }

    @ScriptCallable(returnTypes={ReturnType.STRING})
    public String getSuperclass(@Env(value="target") Object owner) {
        return owner.getClass().getSuperclass().toString();
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE})
    public List<String> getInterfaces(@Env(value="target") Object owner) {
        ArrayList results = Lists.newArrayList();
        for (Class<?> cls : owner.getClass().getInterfaces()) {
            results.add(cls.toString());
        }
        return results;
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE})
    public Map<String, Map<String, Object>> getMethods(@Env(value="target") Object owner) {
        return LuaReflectionHelper.describe(owner.getClass().getMethods());
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE})
    public Map<String, Map<String, Object>> getDeclaredMethods(@Env(value="target") Object owner) {
        return LuaReflectionHelper.describe(owner.getClass().getDeclaredMethods());
    }
}

