/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.MeaningfulIterator;
import appeng.util.item.OreReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ItemList<StackType extends IAEStack>
implements IItemList<StackType> {
    private final NavigableMap<StackType, StackType> records = new ConcurrentSkipListMap<StackType, StackType>();
    private final Class<? extends IAEStack> clz;
    public Throwable stacktrace;
    int iteration = Integer.MIN_VALUE;

    public ItemList(Class<? extends IAEStack> cla) {
        this.clz = cla;
    }

    @Override
    public synchronized void add(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            st.add(option);
            return;
        }
        Object opt = option.copy();
        this.records.put(opt, opt);
    }

    private boolean checkStackType(StackType st) {
        if (st == null) {
            return true;
        }
        if (!this.clz.isInstance(st)) {
            throw new RuntimeException("WRONG TYPE - got " + st.getClass().getName() + " expected " + this.clz.getName());
        }
        return false;
    }

    @Override
    public synchronized StackType findPrecise(StackType i) {
        if (this.checkStackType(i)) {
            return null;
        }
        IAEStack is = (IAEStack)this.records.get(i);
        if (is != null) {
            return (StackType)is;
        }
        return null;
    }

    @Override
    public Collection<StackType> findFuzzy(StackType filter, FuzzyMode fuzzy) {
        if (this.checkStackType(filter)) {
            return new ArrayList();
        }
        if (filter instanceof IAEFluidStack) {
            ArrayList result = Lists.newArrayList();
            if (filter.equals(this)) {
                result.add(filter);
            }
            return result;
        }
        AEItemStack ais = (AEItemStack)filter;
        if (ais.isOre()) {
            OreReference or = ais.def.isOre;
            if (or.getAEEquivalents().size() == 1) {
                IAEItemStack is = or.getAEEquivalents().get(0);
                return this.findFuzzyDamage((AEItemStack)is, fuzzy, is.getItemDamage() == Short.MAX_VALUE);
            }
            LinkedList<StackType> output = new LinkedList<StackType>();
            for (IAEItemStack is : or.getAEEquivalents()) {
                output.addAll(this.findFuzzyDamage((AEItemStack)is, fuzzy, is.getItemDamage() == Short.MAX_VALUE));
            }
            return output;
        }
        return this.findFuzzyDamage(ais, fuzzy, false);
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public Collection<StackType> findFuzzyDamage(AEItemStack filter, FuzzyMode fuzzy, boolean ignoreMeta) {
        IAEItemStack low = filter.getLow(fuzzy, ignoreMeta);
        IAEItemStack high = filter.getHigh(fuzzy, ignoreMeta);
        return this.records.subMap(low, true, high, true).descendingMap().values();
    }

    @Override
    public synchronized void addStorage(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        Object opt = option.copy();
        this.records.put(opt, opt);
    }

    @Override
    public synchronized void addCrafting(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        Object opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.records.put(opt, opt);
    }

    @Override
    public synchronized void addRequestable(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            ((IAEItemStack)st).setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        Object opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(opt.getCountRequestable());
        this.records.put(opt, opt);
    }

    @Override
    public synchronized StackType getFirstItem() {
        Iterator<StackType> i$ = this.iterator();
        if (i$.hasNext()) {
            IAEStack stackType = (IAEStack)i$.next();
            return (StackType)stackType;
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.records.values().size();
    }

    @Override
    public synchronized Iterator<StackType> iterator() {
        return new MeaningfulIterator(this.records.values().iterator());
    }

    @Override
    public synchronized void resetStatus() {
        for (IAEStack i : this) {
            i.reset();
        }
    }
}

