/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.tracking;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.DataEntity;
import mcp.mobius.opis.data.holders.newtypes.PlayerStatus;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionPlayers;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import net.miginfocom.swing.MigLayout;

public class PanelPlayers
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnCenter;
    private JButtonAccess btnTeleport;
    private JButtonAccess btnPull;

    public PanelPlayers() {
        this.setLayout(new MigLayout("", "[][][][][][grow]", "[][grow]"));
        this.btnCenter = new JButtonAccess("Center Map", AccessLevel.NONE);
        this.add((Component)this.btnCenter, "cell 0 0");
        this.btnCenter.addActionListener(new ActionPlayers());
        this.btnTeleport = new JButtonAccess("Teleport", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnTeleport, "cell 1 0");
        this.btnTeleport.addActionListener(new ActionPlayers());
        this.btnPull = new JButtonAccess("Pull", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnPull, "cell 2 0");
        this.btnPull.addActionListener(new ActionPlayers());
        JButton btnKill = new JButton("Kill");
        btnKill.setEnabled(false);
        this.add((Component)btnKill, "cell 3 0");
        JButton btnMorph = new JButton("Morph");
        btnMorph.setEnabled(false);
        this.add((Component)btnMorph, "cell 4 0");
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 6 1,grow");
        this.table = new JTableStats(new String[]{"Name", "Dimension", "Coordinates"}, new Class[]{String.class, Integer.class, Object.class});
        scrollPane.setViewportView(this.table);
    }

    public JButton getBtnCenter() {
        return this.btnCenter;
    }

    public JButton getBtnTeleport() {
        return this.btnTeleport;
    }

    public JButton getBtnPull() {
        return this.btnPull;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_PLAYERS: {
                this.cacheData(msg, rawdata);
                this.getTable().setTableData(rawdata.array);
                DefaultTableModel model = this.getTable().getModel();
                int row = this.getTable().clearTable(DataEntity.class);
                for (ISerializable o : rawdata.array) {
                    PlayerStatus player = (PlayerStatus)o;
                    model.addRow(new Object[]{player.name, player.dim, String.format("[ %4d %4d %4d ]", player.x, player.y, player.z)});
                }
                this.getTable().dataUpdated(row);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.PLAYERS;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

