/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import lib.enderwizards.sandstone.blocks.tile.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockApothecaryCauldron;
import xreliquary.client.particle.EntityCauldronBubbleFX;
import xreliquary.client.particle.EntityCauldronSteamFX;
import xreliquary.items.ItemPotionEssence;
import xreliquary.util.potions.PotionEssence;

public class TileEntityCauldron
extends TileEntityBase {
    public int redstoneCount = 0;
    public PotionEssence potionEssence = null;
    public boolean hasGlowstone = false;
    public boolean hasGunpowder = false;
    public boolean hasNetherwart = false;
    public int cookTime = 0;

    public void func_145845_h() {
        if (this.getHeatSources().contains(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            if (this.potionEssence != null && this.cookTime < this.getCookTime()) {
                ++this.cookTime;
            }
            if (this.field_145850_b.field_72995_K) {
                for (int particleCount = 0; particleCount <= 2; ++particleCount) {
                    this.spawnBoilingParticles();
                }
                if (this.hasGunpowder) {
                    this.spawnGunpowderParticles();
                }
                if (this.hasGlowstone) {
                    this.spawnGlowstoneParticles();
                }
                if (this.hasNetherwart) {
                    this.spawnNetherwartParticles();
                    if (this.potionEssence != null) {
                        this.spawnFinishedParticles();
                    }
                }
                if (this.redstoneCount > 0) {
                    this.spawnRedstoneParticles();
                }
            }
        }
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnBoilingParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(this.getCookTime() * this.getCookTime()) > this.cookTime * this.cookTime) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.33f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.33f;
        int color = this.potionEssence == null ? Integer.parseInt("FFFFFF", 16) : this.getColor(this.potionEssence);
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color >> 0 & 0xFF) / 256.0f;
        EntityCauldronBubbleFX bubble = new EntityCauldronBubbleFX(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)xOffset, (double)this.field_145848_d + 0.01 + (double)BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)), (double)this.field_145849_e + 0.5 + (double)zOffset, 0.0, 0.0, 0.0, red, green, blue);
        EntityCauldronSteamFX steam = new EntityCauldronSteamFX(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)xOffset, (double)this.field_145848_d + 0.01 + (double)BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)), (double)this.field_145849_e + 0.5 + (double)zOffset, 0.0, 0.05 + (double)(0.02f * BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), 0.0, red, green, blue);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)bubble);
        if (this.field_145850_b.field_73012_v.nextInt(6) == 0) {
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)steam);
        }
    }

    public int getColor(PotionEssence essence) {
        return PotionHelper.func_77911_a(essence.getEffects());
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnGunpowderParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 + (double)xOffset, (double)((float)this.field_145848_d + BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), (double)this.field_145849_e + 0.5 + (double)zOffset, 0.0, 0.1, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnGlowstoneParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f);
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_72869_a("mobSpell", (double)this.field_145851_c + 0.5 + (double)xOffset, (double)((float)this.field_145848_d + BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), (double)this.field_145849_e + 0.5 + (double)zOffset, gauss, gauss, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnNetherwartParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        double gauss = 0.5 + (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f);
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_72869_a("mobSpell", (double)this.field_145851_c + 0.5 + (double)xOffset, (double)((float)this.field_145848_d + BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), (double)this.field_145849_e + 0.5 + (double)zOffset, gauss, 0.0, gauss);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnRedstoneParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(10) / this.redstoneCount > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.5 + (double)xOffset, (double)((float)this.field_145848_d + BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), (double)this.field_145849_e + 0.5 + (double)zOffset, 1.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnFinishedParticles() {
        if (this.field_145850_b.field_73012_v.nextInt(8) > 0) {
            return;
        }
        float xOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 1.66f;
        this.field_145850_b.func_72869_a("witchMagic", (double)this.field_145851_c + 0.5 + (double)xOffset, (double)((float)this.field_145848_d + BlockCauldron.func_150025_c((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), (double)this.field_145849_e + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.hasGlowstone = tag.func_74767_n("hasGlowstone");
        this.hasNetherwart = tag.func_74767_n("hasNetherwart");
        this.hasGunpowder = tag.func_74767_n("hasGunpowder");
        this.redstoneCount = tag.func_74762_e("redstoneCount");
        this.cookTime = tag.func_74762_e("cookTime");
        this.potionEssence = new PotionEssence((NBTTagCompound)tag.func_74781_a("potionEssence"));
        if (this.potionEssence.getEffects().size() == 0) {
            this.potionEssence = null;
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("cookTime", this.cookTime);
        tag.func_74768_a("redstoneCount", this.redstoneCount);
        tag.func_74757_a("hasGlowstone", this.hasGlowstone);
        tag.func_74757_a("hasGunpowder", this.hasGunpowder);
        tag.func_74757_a("hasNetherwart", this.hasNetherwart);
        tag.func_74782_a("potionEssence", (NBTBase)(this.potionEssence == null ? new NBTTagCompound() : this.potionEssence.writeToNBT()));
    }

    public boolean finishedCooking() {
        return this.hasNetherwart && this.potionEssence != null && this.cookTime >= this.getCookTime();
    }

    public NBTTagCompound removeContainedPotion() {
        if (!this.hasNetherwart || this.potionEssence == null || this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) <= 0) {
            return null;
        }
        BlockApothecaryCauldron cauldron = (BlockApothecaryCauldron)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        cauldron.setMetaData(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) - 1);
        NBTTagCompound tag = this.getFinishedPotion();
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) <= 0) {
            this.clearAllFields();
        }
        return tag;
    }

    public NBTTagCompound getFinishedPotion() {
        NBTTagCompound tag = this.potionEssence.writeToNBT();
        NBTTagList effectsList = tag.func_150295_c("effects", 10);
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_74782_a("effects", (NBTBase)effectsList);
        newTag.func_74757_a("hasPotion", true);
        if (this.hasGunpowder) {
            newTag.func_74757_a("splash", true);
        }
        return newTag;
    }

    public void clearAllFields() {
        this.cookTime = 0;
        this.hasGlowstone = false;
        this.hasGunpowder = false;
        this.hasNetherwart = false;
        this.redstoneCount = 0;
        this.potionEssence = null;
    }

    public boolean isItemValidForInput(ItemStack ist) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) < 3) {
            return false;
        }
        return ist.func_77973_b() instanceof ItemPotionEssence && this.potionEssence == null || ist.func_77973_b() == Items.field_151016_H && !this.hasGunpowder || ist.func_77973_b() == Items.field_151114_aO && !this.hasGlowstone || ist.func_77973_b() == Items.field_151137_ax && this.redstoneCount <= this.getRedstoneAmpLimit() || ist.func_77973_b() == Items.field_151075_bm && !this.hasNetherwart;
    }

    public void addItem(ItemStack ist) {
        if (ist.func_77973_b() instanceof ItemPotionEssence) {
            this.potionEssence = new PotionEssence(ist.func_77978_p());
        } else if (ist.func_77973_b() == Items.field_151016_H) {
            this.hasGunpowder = true;
        } else if (ist.func_77973_b() == Items.field_151114_aO) {
            this.hasGlowstone = true;
        } else if (ist.func_77973_b() == Items.field_151137_ax) {
            ++this.redstoneCount;
        } else if (ist.func_77973_b() == Items.field_151075_bm) {
            this.hasNetherwart = true;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getRedstoneAmpLimit() {
        return Reliquary.CONFIG.getInt("apothecary_cauldron", "redstone_limit");
    }

    public List<Block> getHeatSources() {
        ArrayList<Block> heatSources = new ArrayList<Block>();
        List heatSourceBlockNames = (List)Reliquary.CONFIG.get("apothecary_cauldron", "heat_sources");
        for (String blockName : heatSourceBlockNames) {
            if (heatSources.contains(Reliquary.CONTENT.getBlock(blockName))) continue;
            heatSources.add(Reliquary.CONTENT.getBlock(blockName));
        }
        heatSources.add(Blocks.field_150353_l);
        heatSources.add((Block)Blocks.field_150356_k);
        heatSources.add((Block)Blocks.field_150480_ab);
        return heatSources;
    }

    public int getCookTime() {
        return Reliquary.CONFIG.getInt("apothecary_cauldron", "cook_time");
    }
}

