/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils;

import com.mojang.authlib.GameProfile;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.entity.EntityCelebrity;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.UsernameUtils;
import ganymedes01.headcrumbs.utils.Utils;
import ganymedes01.headcrumbs.utils.helpers.EnderZooHelper;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelper;
import ganymedes01.headcrumbs.utils.helpers.NaturaHelper;
import ganymedes01.headcrumbs.utils.helpers.TEHelper;
import ganymedes01.headcrumbs.utils.helpers.ThaumcraftHelper;
import ganymedes01.headcrumbs.utils.helpers.TwilightForestHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;

public class HeadUtils {
    private static final String OWNER_TAG = "SkullOwner";
    public static final List<ItemStack> players = new LinkedList<ItemStack>();
    public static boolean twilightForest = false;
    public static boolean thermalExpansion = false;
    public static boolean natura = false;
    public static boolean thaumcraft = false;
    public static boolean lycanites = false;
    public static boolean enderzoo = false;

    public static void loadPlayerHeads() {
        Random rand = new Random();
        LinkedList<String> allNames = new LinkedList<String>();
        allNames.addAll(Arrays.asList(Headcrumbs.others));
        allNames.addAll(Arrays.asList(Headcrumbs.modders));
        allNames.addAll(Arrays.asList(Headcrumbs.youtubers));
        allNames.addAll(Arrays.asList(Headcrumbs.mojang));
        allNames.addAll(Arrays.asList(Headcrumbs.mindCrack));
        allNames.addAll(Arrays.asList(Headcrumbs.forgeCraft));
        allNames.addAll(Arrays.asList(Headcrumbs.ftb));
        Collections.sort(allNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
        });
        for (String name : allNames) {
            if ((name = name.trim()) == null || name.isEmpty()) continue;
            ItemStack head = HeadUtils.createHeadFor(name);
            if (Headcrumbs.addPlayerHeadsAsDungeonLoot) {
                rand.setSeed(name.hashCode());
                Utils.addDungeonLoot(head.func_77946_l(), 1, 1, 1 + rand.nextInt(Headcrumbs.headsDungeonLootMaxWeight));
                Utils.addStrongholdLoot(head.func_77946_l(), 1, 1, 2 + rand.nextInt(Math.max(1, Headcrumbs.headsDungeonLootMaxWeight - 1)));
            }
            players.add(head);
        }
    }

    public static ItemStack getHeadfromEntity(EntityLivingBase target) {
        ItemStack head;
        if (target.func_70631_g_()) {
            return null;
        }
        if (twilightForest && (head = TwilightForestHelper.getHead((Entity)target)) != null) {
            return head;
        }
        if (thermalExpansion && (head = TEHelper.getHead((Entity)target)) != null) {
            return head;
        }
        if (natura && (head = NaturaHelper.getHead((Entity)target)) != null) {
            return head;
        }
        if (thaumcraft && (head = ThaumcraftHelper.getHead((Entity)target)) != null) {
            return head;
        }
        if (lycanites && (head = LycanitesHelper.getHead((Entity)target)) != null) {
            return head;
        }
        if (enderzoo && (head = EnderZooHelper.getHead((Entity)target)) != null) {
            return head;
        }
        if (target instanceof EntityCelebrity) {
            return HeadUtils.createHeadFor(((EntityCelebrity)target).getUsername());
        }
        if (target instanceof EntityMob) {
            if (target instanceof EntityCreeper) {
                return new ItemStack(Items.field_151144_bL, 1, 4);
            }
            if (target instanceof EntitySkeleton) {
                int type = ((EntitySkeleton)target).func_82202_m();
                if (type == 1) {
                    return new ItemStack(Items.field_151144_bL, 1, 1);
                }
                if (type == 0) {
                    return new ItemStack(Items.field_151144_bL, 1, 0);
                }
            } else {
                if (target instanceof EntityZombie) {
                    if (target instanceof EntityPigZombie) {
                        return new ItemStack(ModItems.skull, 1, SkullTypes.pigman.ordinal());
                    }
                    if (((EntityZombie)target).func_82231_m()) {
                        return new ItemStack(ModItems.skull, 1, SkullTypes.zombieVillager.ordinal());
                    }
                    return new ItemStack(Items.field_151144_bL, 1, 2);
                }
                if (target instanceof EntityEnderman) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.enderman.ordinal());
                }
                if (target instanceof EntityBlaze) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.blaze.ordinal());
                }
                if (target instanceof EntitySpider) {
                    if (target instanceof EntityCaveSpider) {
                        return new ItemStack(ModItems.skull, 1, SkullTypes.caveSpider.ordinal());
                    }
                    return new ItemStack(ModItems.skull, 1, SkullTypes.spider.ordinal());
                }
                if (target instanceof EntityWitch) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.witch.ordinal());
                }
                if (target instanceof EntityWither) {
                    return new ItemStack(ModItems.skull, 1 + (target.field_70170_p.field_73012_v.nextInt(100) == 0 ? 1 + target.field_70170_p.field_73012_v.nextInt(2) : 0), SkullTypes.wither.ordinal());
                }
                if (target instanceof EntitySilverfish) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.silverfish.ordinal());
                }
            }
        } else {
            if (target instanceof EntityPlayer) {
                return HeadUtils.createHeadFor((EntityPlayer)target);
            }
            if (target instanceof EntityAnimal) {
                if (target instanceof EntityPig) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.pig.ordinal());
                }
                if (target instanceof EntityCow) {
                    if (target instanceof EntityMooshroom) {
                        return new ItemStack(ModItems.skull, 1, SkullTypes.mooshroom.ordinal());
                    }
                    return new ItemStack(ModItems.skull, 1, SkullTypes.cow.ordinal());
                }
                if (target instanceof EntitySheep) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.sheep.ordinal());
                }
                if (target instanceof EntityWolf) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.wolf.ordinal());
                }
                if (target instanceof EntityChicken) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.chicken.ordinal());
                }
                if (target instanceof EntityOcelot) {
                    switch (((EntityOcelot)target).func_70913_u()) {
                        case 0: {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.ocelot.ordinal());
                        }
                        case 1: {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.ocelotBlack.ordinal());
                        }
                        case 2: {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.ocelotRed.ordinal());
                        }
                        case 3: {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.ocelotSiamese.ordinal());
                        }
                    }
                } else if (target instanceof EntityHorse) {
                    int type = ((EntityHorse)target).func_110265_bP();
                    if (type == 0) {
                        switch (((EntityHorse)target).func_110202_bQ() & 0xFF) {
                            case 0: {
                                return new ItemStack(ModItems.skull, 1, SkullTypes.horseWhite.ordinal());
                            }
                            case 1: {
                                return new ItemStack(ModItems.skull, 1, SkullTypes.horseCreamy.ordinal());
                            }
                            case 2: {
                                return new ItemStack(ModItems.skull, 1, SkullTypes.horseChestnut.ordinal());
                            }
                            case 3: {
                                return new ItemStack(ModItems.skull, 1, SkullTypes.horseBrown.ordinal());
                            }
                            case 4: {
                                return new ItemStack(ModItems.skull, 1, SkullTypes.horseBlack.ordinal());
                            }
                            case 5: {
                                return new ItemStack(ModItems.skull, 1, SkullTypes.horseGrey.ordinal());
                            }
                            case 6: {
                                return new ItemStack(ModItems.skull, 1, SkullTypes.horseDarkBrown.ordinal());
                            }
                        }
                    } else {
                        if (type == 1) {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.donkey.ordinal());
                        }
                        if (type == 2) {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.mule.ordinal());
                        }
                        if (type == 3) {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.horseUndead.ordinal());
                        }
                        if (type == 4) {
                            return new ItemStack(ModItems.skull, 1, SkullTypes.horseSkeleton.ordinal());
                        }
                    }
                }
            } else {
                if (target instanceof EntityVillager) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.villager.ordinal());
                }
                if (target instanceof EntityIronGolem) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.ironGolem.ordinal());
                }
                if (target instanceof EntitySquid) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.squid.ordinal());
                }
                if (target instanceof EntityGhast) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.ghast.ordinal());
                }
                if (target instanceof EntityDragon) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.enderDragon.ordinal());
                }
                if (target instanceof EntityBat) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.bat.ordinal());
                }
                if (target instanceof EntitySlime && ((EntitySlime)target).func_70809_q() == 1) {
                    if (target instanceof EntityMagmaCube) {
                        return new ItemStack(ModItems.skull, 1, SkullTypes.magmaCube.ordinal());
                    }
                    return new ItemStack(ModItems.skull, 1, SkullTypes.slime.ordinal());
                }
                if (target instanceof EntitySnowman) {
                    return new ItemStack(ModItems.skull, 1, SkullTypes.snowMan.ordinal());
                }
            }
        }
        return null;
    }

    public static ItemStack createHeadFor(String username) {
        return HeadUtils.createHeadFor(new GameProfile(null, UsernameUtils.getFixedUsername(username)));
    }

    public static ItemStack createHeadFor(EntityPlayer player) {
        return HeadUtils.createHeadFor(player.func_146103_bH());
    }

    public static ItemStack createHeadFor(GameProfile profile) {
        ItemStack stack = new ItemStack(ModItems.skull, 1, SkullTypes.player.ordinal());
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound profileData = new NBTTagCompound();
        NBTUtil.func_152460_a((NBTTagCompound)profileData, (GameProfile)profile);
        stack.func_77978_p().func_74782_a(OWNER_TAG, (NBTBase)profileData);
        return stack;
    }

    public static GameProfile getGameProfile(ItemStack stack) {
        GameProfile profile = null;
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_150297_b(OWNER_TAG, 10)) {
                profile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l(OWNER_TAG));
            } else if (nbt.func_150297_b(OWNER_TAG, 8)) {
                profile = new GameProfile(null, nbt.func_74779_i(OWNER_TAG));
            } else if (nbt.func_150297_b("OwnerUUID", 8)) {
                profile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(UUID.fromString(nbt.func_74779_i("OwnerUUID")));
                profile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(profile, true);
            }
        }
        return profile;
    }

    public static String getName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_150297_b(OWNER_TAG, 10)) {
                GameProfile profile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l(OWNER_TAG));
                if (profile != null) {
                    return profile.getName();
                }
            } else if (nbt.func_150297_b(OWNER_TAG, 8)) {
                return nbt.func_74779_i(OWNER_TAG);
            }
        }
        return null;
    }
}

