/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.util.Lang;
import net.minecraft.tileentity.TileEntity;

public enum RedstoneControlMode {
    IGNORE,
    ON,
    OFF,
    NEVER;


    public String getTooltip() {
        return Lang.localize("gui.tooltip.redstoneControlMode." + this.name().toLowerCase());
    }

    public static boolean isConditionMet(RedstoneControlMode redstoneControlMode, int powerLevel) {
        boolean redstoneCheckPassed = true;
        if (redstoneControlMode == NEVER) {
            redstoneCheckPassed = false;
        } else if (redstoneControlMode == ON) {
            if (powerLevel < 1) {
                redstoneCheckPassed = false;
            }
        } else if (redstoneControlMode == OFF && powerLevel > 0) {
            redstoneCheckPassed = false;
        }
        return redstoneCheckPassed;
    }

    public static boolean isConditionMet(RedstoneControlMode redstoneControlMode, TileEntity te) {
        return RedstoneControlMode.isConditionMet(redstoneControlMode, te.func_145831_w().func_94572_D(te.field_145851_c, te.field_145848_d, te.field_145849_e));
    }

    public RedstoneControlMode next() {
        int ord = this.ordinal();
        ord = ord == RedstoneControlMode.values().length - 1 ? 0 : ++ord;
        return RedstoneControlMode.values()[ord];
    }

    public RedstoneControlMode previous() {
        int ord = this.ordinal();
        if (--ord < 0) {
            ord = RedstoneControlMode.values().length - 1;
        }
        return RedstoneControlMode.values()[ord];
    }
}

