/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerPartEssentiaStorageBus;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.gui.abstraction.AbstractGuiBase;
import thaumicenergistics.gui.buttons.ButtonAETab;
import thaumicenergistics.gui.buttons.ButtonAllowVoid;
import thaumicenergistics.gui.widget.AbstractWidget;
import thaumicenergistics.gui.widget.WidgetAspectSlot;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.network.IAspectSlotGui;
import thaumicenergistics.network.packet.server.PacketServerChangeGui;
import thaumicenergistics.network.packet.server.PacketServerEssentiaStorageBus;
import thaumicenergistics.parts.AEPartEssentiaStorageBus;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.AEStateIconsEnum;
import thaumicenergistics.texture.GuiTextureManager;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaStorageBus
extends AbstractGuiBase
implements IAspectSlotGui {
    private static final int COLUMNS = 3;
    private static final int ROWS = 3;
    private static final int WIDGET_X_POS = 61;
    private static final int WIDGET_Y_POS = 21;
    private static final int GUI_WIDTH_NETWORK_TOOL = 246;
    private static final int GUI_WIDTH_NO_TOOL = 210;
    private static final int GUI_HEIGHT = 184;
    private static final int TITLE_X_POS = 6;
    private static final int TITLE_Y_POS = 5;
    private static final int BUTTON_PRIORITY_ID = 0;
    private static final int BUTTON_PRIORITY_X_POSITION = 154;
    private static final int BUTTON_ALLOW_VOID_ID = 1;
    private static final int BUTTON_ALLOW_VOID_X_POS = -18;
    private static final int BUTTON_ALLOW_VOID_Y_POS = 8;
    private EntityPlayer player;
    private List<WidgetAspectSlot> aspectWidgetList = new ArrayList<WidgetAspectSlot>();
    private List<Aspect> filteredAspects = new ArrayList<Aspect>();
    private boolean hasNetworkTool;
    private AEPartEssentiaStorageBus storageBus;
    private final String guiTitle = AEPartsEnum.EssentiaStorageBus.getLocalizedName();
    private boolean isVoidAllowed = false;

    public GuiEssentiaStorageBus(AEPartEssentiaStorageBus storageBus, EntityPlayer player) {
        super(new ContainerPartEssentiaStorageBus(storageBus, player));
        this.player = player;
        this.storageBus = storageBus;
        this.hasNetworkTool = ((ContainerPartEssentiaStorageBus)this.field_147002_h).hasNetworkTool();
        this.field_146999_f = this.hasNetworkTool ? 246 : 210;
        this.field_147000_g = 184;
    }

    @Override
    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_STORAGE_BUS.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 222);
        this.func_73729_b(this.field_147003_i + 179, this.field_147009_r, 179, 0, 32, 32);
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i + 179, this.field_147009_r + 93, 178, 93, 68, 68);
        }
        super.func_146976_a(alpha, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (WidgetAspectSlot aspectSlot : this.aspectWidgetList) {
            if (!aspectSlot.isMouseOverWidget(mouseX, mouseY)) continue;
            Aspect itemAspect = EssentiaItemContainerHelper.instance.getAspectInContainer(this.player.field_71071_by.func_70445_o());
            if (itemAspect != null && this.filteredAspects.contains(itemAspect)) {
                return;
            }
            aspectSlot.mouseClicked(itemAspect);
            break;
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            TileEntity host = this.storageBus.getHostTile();
            ForgeDirection side = this.storageBus.getSide();
            new PacketServerChangeGui().createChangeGuiRequest(ThEGuiHandler.generatePriorityID(side), this.player, host.func_145831_w(), host.field_145851_c, host.field_145848_d, host.field_145849_e).sendPacketToServer();
        } else if (button.field_146127_k == 1) {
            ((ButtonAllowVoid)((Object)this.field_146292_n.get((int)1))).isVoidAllowed = this.isVoidAllowed = !this.isVoidAllowed;
            new PacketServerEssentiaStorageBus().createRequestSetVoidAllowed(this.player, this.storageBus, this.isVoidAllowed).sendPacketToServer();
        }
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.guiTitle, 6, 5, 0);
        WidgetAspectSlot slotUnderMouse = null;
        for (WidgetAspectSlot currentWidget : this.aspectWidgetList) {
            if (slotUnderMouse == null && currentWidget.canRender() && currentWidget.isMouseOverWidget(mouseX, mouseY)) {
                currentWidget.drawMouseHoverUnderlay();
                slotUnderMouse = currentWidget;
            }
            currentWidget.drawWidget();
        }
        if (slotUnderMouse != null) {
            slotUnderMouse.getTooltip(this.tooltip);
        } else {
            this.addTooltipFromButtons(mouseX, mouseY);
        }
        this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, true);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                this.aspectWidgetList.add(new WidgetAspectSlot(this, this.player, this.storageBus, row * 3 + column, 61 + AbstractWidget.WIDGET_SIZE * column, 21 + AbstractWidget.WIDGET_SIZE * row));
            }
        }
        this.field_146292_n.add(new ButtonAETab(0, this.field_147003_i + 154, this.field_147009_r, AEStateIconsEnum.WRENCH, "gui.appliedenergistics2.Priority"));
        this.field_146292_n.add(new ButtonAllowVoid(1, this.field_147003_i + -18, this.field_147009_r + 8));
        new PacketServerEssentiaStorageBus().createRequestFullUpdate(this.player, this.storageBus).sendPacketToServer();
    }

    public void onServerSentVoidMode(boolean isVoidAllowed) {
        ((ButtonAllowVoid)((Object)this.field_146292_n.get((int)1))).isVoidAllowed = this.isVoidAllowed = isVoidAllowed;
    }

    @Override
    public void updateAspects(List<Aspect> aspectList) {
        int count = Math.min(this.aspectWidgetList.size(), aspectList.size());
        for (int i = 0; i < count; ++i) {
            this.aspectWidgetList.get(i).setAspect(aspectList.get(i));
        }
        this.filteredAspects = aspectList;
    }
}

