/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class DefaultISBRH
implements ISimpleBlockRenderingHandler {
    private static final Quad[] quads = new Quad[]{new Quad(new Vt(0, 0, 0), new Vt(1, 0, 0), new Vt(1, 0, 1), new Vt(0, 0, 1)), new Quad(new Vt(0, 1, 1), new Vt(1, 1, 1), new Vt(1, 1, 0), new Vt(0, 1, 0)), new Quad(new Vt(1, 1, 0), new Vt(1, 0, 0), new Vt(0, 0, 0), new Vt(0, 1, 0)), new Quad(new Vt(1, 0, 1), new Vt(1, 1, 1), new Vt(0, 1, 1), new Vt(0, 0, 1)), new Quad(new Vt(0, 0, 1), new Vt(0, 1, 1), new Vt(0, 1, 0), new Vt(0, 0, 0)), new Quad(new Vt(1, 0, 0), new Vt(1, 1, 0), new Vt(1, 1, 1), new Vt(1, 0, 1))};

    public static void addSideFullTexture(Tessellator tessellator, int side, float mult, float offset) {
        float u1 = 0.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        Quad quad = quads[side];
        tessellator.func_78374_a((double)((float)quad.v1.x * mult + offset), (double)((float)quad.v1.y * mult + offset), (double)((float)quad.v1.z * mult + offset), (double)u1, (double)v1);
        tessellator.func_78374_a((double)((float)quad.v2.x * mult + offset), (double)((float)quad.v2.y * mult + offset), (double)((float)quad.v2.z * mult + offset), (double)u1, (double)v2);
        tessellator.func_78374_a((double)((float)quad.v3.x * mult + offset), (double)((float)quad.v3.y * mult + offset), (double)((float)quad.v3.z * mult + offset), (double)u2, (double)v2);
        tessellator.func_78374_a((double)((float)quad.v4.x * mult + offset), (double)((float)quad.v4.y * mult + offset), (double)((float)quad.v4.z * mult + offset), (double)u2, (double)v1);
    }

    public static void addSide(Block block, Tessellator tessellator, int side, int meta) {
        IIcon c = block.func_149691_a(side, meta);
        DefaultISBRH.addSide(tessellator, side, c);
    }

    public static void addSideConditionally(IBlockAccess world, int x, int y, int z, Block block, Tessellator tessellator, IIcon icon, ForgeDirection direction) {
        if (block.func_149646_a(world, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, direction.ordinal())) {
            DefaultISBRH.addSide(tessellator, direction.ordinal(), icon);
        }
    }

    public static void addSide(Tessellator tessellator, int side, IIcon c) {
        float u1 = c.func_94209_e();
        float v1 = c.func_94206_g();
        float u2 = c.func_94212_f();
        float v2 = c.func_94210_h();
        Quad quad = quads[side];
        tessellator.func_78374_a((double)quad.v1.x, (double)quad.v1.y, (double)quad.v1.z, (double)u1, (double)v1);
        tessellator.func_78374_a((double)quad.v2.x, (double)quad.v2.y, (double)quad.v2.z, (double)u1, (double)v2);
        tessellator.func_78374_a((double)quad.v3.x, (double)quad.v3.y, (double)quad.v3.z, (double)u2, (double)v2);
        tessellator.func_78374_a((double)quad.v4.x, (double)quad.v4.y, (double)quad.v4.z, (double)u2, (double)v1);
    }

    public static void addSideShifted(IIcon c, Tessellator tessellator, int side, double dx, double dy, double dz) {
        float u1 = c.func_94209_e();
        float v1 = c.func_94206_g();
        float u2 = c.func_94212_f();
        float v2 = c.func_94210_h();
        Quad quad = quads[side];
        tessellator.func_78374_a((double)quad.v1.x + dx, (double)quad.v1.y + dy, (double)quad.v1.z + dz, (double)u1, (double)v1);
        tessellator.func_78374_a((double)quad.v2.x + dx, (double)quad.v2.y + dy, (double)quad.v2.z + dz, (double)u1, (double)v2);
        tessellator.func_78374_a((double)quad.v3.x + dx, (double)quad.v3.y + dy, (double)quad.v3.z + dz, (double)u2, (double)v2);
        tessellator.func_78374_a((double)quad.v4.x + dx, (double)quad.v4.y + dy, (double)quad.v4.z + dz, (double)u2, (double)v1);
    }

    public static void addSideHeight(Block block, Tessellator tessellator, int side, int meta, double height) {
        IIcon c = block.func_149691_a(side, meta);
        float u1 = c.func_94209_e();
        float v1 = c.func_94206_g();
        float u2 = c.func_94212_f();
        float v2 = c.func_94210_h();
        Quad quad = quads[side];
        tessellator.func_78374_a((double)quad.v1.x, (double)quad.v1.y * height, (double)quad.v1.z, (double)u1, (double)v1);
        tessellator.func_78374_a((double)quad.v2.x, (double)quad.v2.y * height, (double)quad.v2.z, (double)u1, (double)v2);
        tessellator.func_78374_a((double)quad.v3.x, (double)quad.v3.y * height, (double)quad.v3.z, (double)u2, (double)v2);
        tessellator.func_78374_a((double)quad.v4.x, (double)quad.v4.y * height, (double)quad.v4.z, (double)u2, (double)v1);
    }

    public static void addSideHeightWithRotation(Block block, Tessellator tessellator, int side, int meta, double height, ForgeDirection rotation) {
        IIcon c = block.func_149691_a(side, meta);
        DefaultISBRH.addSideHeightWithRotation(tessellator, side, height, rotation, c);
    }

    public static void addSideHeightWithRotation(Tessellator tessellator, int side, double height, ForgeDirection rotation, IIcon c) {
        float u1 = c.func_94209_e();
        float v1 = c.func_94206_g();
        float u2 = c.func_94212_f();
        float v2 = c.func_94210_h();
        Quad quad = quads[side].rotate(rotation);
        tessellator.func_78374_a((double)quad.v1.x, (double)quad.v1.y * height, (double)quad.v1.z, (double)u1, (double)v1);
        tessellator.func_78374_a((double)quad.v2.x, (double)quad.v2.y * height, (double)quad.v2.z, (double)u1, (double)v2);
        tessellator.func_78374_a((double)quad.v3.x, (double)quad.v3.y * height, (double)quad.v3.z, (double)u2, (double)v2);
        tessellator.func_78374_a((double)quad.v4.x, (double)quad.v4.y * height, (double)quad.v4.z, (double)u2, (double)v1);
    }

    protected void drawInventoryBlock(Block block, int meta, RenderBlocks renderer) {
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.WEST.ordinal(), meta));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.EAST.ordinal(), meta));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.NORTH.ordinal(), meta));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.SOUTH.ordinal(), meta));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.DOWN.ordinal(), meta));
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, ForgeDirection.UP.ordinal(), meta));
        t.func_78381_a();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.drawInventoryBlock(block, metadata, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    private static class Quad {
        public final Vt v1;
        public final Vt v2;
        public final Vt v3;
        public final Vt v4;

        public Quad(Vt v1, Vt v2, Vt v3, Vt v4) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
        }

        public Quad rotate(ForgeDirection direction) {
            switch (direction) {
                case NORTH: {
                    return new Quad(this.v4, this.v1, this.v2, this.v3);
                }
                case EAST: {
                    return new Quad(this.v3, this.v4, this.v1, this.v2);
                }
                case SOUTH: {
                    return new Quad(this.v2, this.v3, this.v4, this.v1);
                }
                case WEST: {
                    return this;
                }
            }
            return this;
        }
    }

    private static class Vt {
        public final int x;
        public final int y;
        public final int z;

        public Vt(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

