/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.events.ValueEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.ScrollableLabel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.blocks.monitor.LiquidMonitorBlockTileEntity;
import mcjty.rftools.blocks.monitor.PacketContentsMonitor;
import mcjty.rftools.blocks.monitor.PacketGetAdjacentTankBlocks;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import mcjty.rftools.network.PacketHandler;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;

public class GuiLiquidMonitor
extends GenericGuiContainer<LiquidMonitorBlockTileEntity> {
    private WidgetList list;
    private ChoiceLabel alarmModeChoiceLabel;
    private ScrollableLabel alarmLabel;
    private int listDirty;
    public static final int TEXT_COLOR = 1677215;
    private List<Coordinate> adjacentBlocks = null;
    public static List<Coordinate> fromServer_clientAdjacentBlocks = null;

    public GuiLiquidMonitor(LiquidMonitorBlockTileEntity liquidMonitorBlockTileEntity, Container container) {
        super(liquidMonitorBlockTileEntity, container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int xSize = 256;
        int ySize = 180;
        int k = (this.field_146294_l - xSize) / 2;
        int l = (this.field_146295_m - ySize) / 2;
        this.list = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent(new DefaultSelectionEvent(){

            @Override
            public void select(Widget parent, int index) {
                GuiLiquidMonitor.this.setSelectedBlock(index);
            }
        });
        this.listDirty = 0;
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(15)).setVertical().setScrollable(this.list);
        Panel listPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.list)).addChild(listSlider);
        this.alarmModeChoiceLabel = ((ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(RFMonitorMode.MODE_OFF.getDescription(), RFMonitorMode.MODE_LESS.getDescription(), RFMonitorMode.MODE_MORE.getDescription()).setDesiredWidth(60)).setDesiredHeight(15)).setTooltips(new String[]{"Control when a redstone", "signal should be sent"})).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiLiquidMonitor.this.changeAlarmMode(RFMonitorMode.getModeFromDescription(newChoice));
            }
        });
        this.alarmModeChoiceLabel.setChoice(((LiquidMonitorBlockTileEntity)this.tileEntity).getAlarmMode().getDescription());
        this.alarmLabel = ((ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).setSuffix("%").setDesiredWidth(30)).setRealMinimum(0).setRealMaximum(100).setRealValue(((LiquidMonitorBlockTileEntity)this.tileEntity).getAlarmLevel()).addValueEvent(new ValueEvent(){

            @Override
            public void valueChanged(Widget parent, int newValue) {
                GuiLiquidMonitor.this.changeAlarmValue(newValue);
            }
        });
        Slider alarmSlider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredHeight(15)).setHorizontal().setTooltips(new String[]{"Alarm level"})).setScrollable(this.alarmLabel);
        Panel alarmPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.alarmModeChoiceLabel)).addChild(alarmSlider)).addChild(this.alarmLabel)).setDesiredHeight(20);
        Object toplevel = ((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout(new VerticalLayout()).addChild(listPanel)).addChild(alarmPanel);
        toplevel.setBounds(new Rectangle(k, l, xSize, ySize));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        fromServer_clientAdjacentBlocks = new ArrayList<Coordinate>();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetAdjacentTankBlocks(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e));
    }

    private void changeAlarmMode(RFMonitorMode mode) {
        int alarmLevel = this.alarmLabel.getRealValue();
        ((LiquidMonitorBlockTileEntity)this.tileEntity).setAlarm(mode, alarmLevel);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, mode, alarmLevel));
    }

    private void changeAlarmValue(int newValue) {
        RFMonitorMode mode = RFMonitorMode.getModeFromDescription(this.alarmModeChoiceLabel.getCurrentChoice());
        ((LiquidMonitorBlockTileEntity)this.tileEntity).setAlarm(mode, newValue);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, mode, newValue));
    }

    private void refreshList() {
    }

    private void setSelectedBlock(int index) {
        if (index != -1) {
            Coordinate c = this.adjacentBlocks.get(index);
            ((LiquidMonitorBlockTileEntity)this.tileEntity).setMonitor(c);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, c));
        } else {
            ((LiquidMonitorBlockTileEntity)this.tileEntity).setInvalid();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketContentsMonitor(((LiquidMonitorBlockTileEntity)this.tileEntity).field_145851_c, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145848_d, ((LiquidMonitorBlockTileEntity)this.tileEntity).field_145849_e, Coordinate.INVALID));
        }
    }

    private void populateList() {
        List<Coordinate> newAdjacentBlocks = fromServer_clientAdjacentBlocks;
        if (newAdjacentBlocks == null) {
            return;
        }
        if (((Object)newAdjacentBlocks).equals(this.adjacentBlocks)) {
            this.refreshList();
            return;
        }
        this.adjacentBlocks = new ArrayList<Coordinate>(newAdjacentBlocks);
        this.list.removeChildren();
        int index = 0;
        int sel = -1;
        for (Coordinate coordinate : this.adjacentBlocks) {
            Block block = this.field_146297_k.field_71441_e.func_147439_a(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            int meta = this.field_146297_k.field_71441_e.func_72805_g(coordinate.getX(), coordinate.getY(), coordinate.getZ());
            int color = 1677215;
            String displayName = BlockInfo.getReadableName(block, coordinate, meta, (World)this.field_146297_k.field_71441_e);
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout());
            panel.addChild(new BlockRender(this.field_146297_k, (Gui)this).setRenderItem(block));
            panel.addChild(((AbstractWidget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(displayName)).setColor(color)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(90));
            panel.addChild((Widget)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setDynamic(true)).setText(coordinate.toString())).setColor(color));
            this.list.addChild(panel);
            if (coordinate.getX() == ((LiquidMonitorBlockTileEntity)this.tileEntity).getMonitorX() && coordinate.getY() == ((LiquidMonitorBlockTileEntity)this.tileEntity).getMonitorY() && coordinate.getZ() == ((LiquidMonitorBlockTileEntity)this.tileEntity).getMonitorZ()) {
                sel = index;
            }
            ++index;
        }
        this.list.setSelected(sel);
    }

    protected void func_146976_a(float v, int i, int i2) {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 5;
        }
        this.window.draw();
    }
}

