/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.mobiuscore.asm.transformers.common;

import mcp.mobius.mobiuscore.asm.ObfTable;
import mcp.mobius.mobiuscore.asm.transformers.TransformerBase;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TransformerWorldServer
extends TransformerBase {
    private static String WORLDSERVER_TICK;
    private static AbstractInsnNode[] WORLDSERVER_PAYLOAD_TICKSTART;
    private static AbstractInsnNode[] WORLDSERVER_PAYLOAD_TICKEND;

    @Override
    public byte[] transform(String name, String srgname, byte[] bytes) {
        TransformerWorldServer.dumpChecksum(bytes, name, srgname);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode tickNode = this.getMethod(classNode, WORLDSERVER_TICK);
        this.applyPayloadFirst(tickNode, WORLDSERVER_PAYLOAD_TICKSTART);
        this.applyPayloadLast(tickNode, WORLDSERVER_PAYLOAD_TICKEND);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        String profilerClass = ProfilerSection.getClassName();
        String profilerType = ProfilerSection.getTypeName();
        WORLDSERVER_TICK = ObfTable.WORLDSERVER_TICK.getFullDescriptor();
        WORLDSERVER_PAYLOAD_TICKSTART = new AbstractInsnNode[]{new FieldInsnNode(178, profilerClass, ProfilerSection.DIMENSION_BLOCKTICK.name(), profilerType), new VarInsnNode(25, 0), new FieldInsnNode(180, ObfTable.WORLD_PROVIDER.getClazz(), ObfTable.WORLD_PROVIDER.getName(), ObfTable.WORLD_PROVIDER.getDescriptor()), new FieldInsnNode(180, ObfTable.WORLDPROVIDER_DIMID.getClazz(), ObfTable.WORLDPROVIDER_DIMID.getName(), ObfTable.WORLDPROVIDER_DIMID.getDescriptor()), new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;"), new MethodInsnNode(182, profilerClass, "start", "(Ljava/lang/Object;)V")};
        WORLDSERVER_PAYLOAD_TICKEND = new AbstractInsnNode[]{new FieldInsnNode(178, profilerClass, ProfilerSection.DIMENSION_BLOCKTICK.name(), profilerType), new VarInsnNode(25, 0), new FieldInsnNode(180, ObfTable.WORLD_PROVIDER.getClazz(), ObfTable.WORLD_PROVIDER.getName(), ObfTable.WORLD_PROVIDER.getDescriptor()), new FieldInsnNode(180, ObfTable.WORLDPROVIDER_DIMID.getClazz(), ObfTable.WORLDPROVIDER_DIMID.getName(), ObfTable.WORLDPROVIDER_DIMID.getDescriptor()), new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;"), new MethodInsnNode(182, profilerClass, "stop", "(Ljava/lang/Object;)V")};
    }
}

