/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.Log;
import openmods.block.OpenBlock;
import openmods.renderer.IBlockRenderer;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class DefaultBlockRenderer
implements IBlockRenderer<Block> {
    private final Map<Block, TileEntity> inventoryTileEntities = Maps.newIdentityHashMap();

    public TileEntity getTileEntityForBlock(OpenBlock block) {
        TileEntity te = this.inventoryTileEntities.get(block);
        if (te == null) {
            te = block.createTileEntityForRender();
            this.inventoryTileEntities.put(block, te);
        }
        return te;
    }

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        OpenBlock openBlock = block instanceof OpenBlock ? (OpenBlock)block : null;
        TileEntity te = openBlock != null && openBlock.shouldRenderTesrInInventory() ? this.getTileEntityForBlock(openBlock) : null;
        if (te instanceof OpenTileEntity) {
            ((OpenTileEntity)te).prepareForInventoryRender(block, metadata);
        }
        try {
            GL11.glEnable((int)32826);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (te != null) {
                GL11.glPushAttrib((int)262144);
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, 0.0, 0.0, 0.0, 0.0f);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (openBlock == null || openBlock.shouldRenderBlock()) {
                ForgeDirection rotation;
                if (openBlock != null) {
                    rotation = openBlock.getInventoryRenderRotation();
                    openBlock.setBoundsBasedOnRotation(rotation);
                    RenderUtils.rotateFacesOnRenderer(openBlock, rotation, renderer);
                } else {
                    rotation = ForgeDirection.EAST;
                }
                RenderUtils.renderInventoryBlock(renderer, block, rotation);
                RenderUtils.resetFacesOnRenderer(renderer);
            }
        }
        catch (Exception e) {
            Log.severe(e, "Error during block '%s' rendering", block.func_149739_a());
        }
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        OpenBlock openBlock;
        OpenBlock openBlock2 = openBlock = block instanceof OpenBlock ? (OpenBlock)block : null;
        if (openBlock == null || openBlock.shouldRenderBlock()) {
            if (openBlock != null) {
                int metadata = world.func_72805_g(x, y, z);
                ForgeDirection rotation = ForgeDirection.getOrientation((int)metadata);
                RenderUtils.rotateFacesOnRenderer((OpenBlock)block, rotation, renderer);
            }
            renderer.func_147784_q(block, x, y, z);
            RenderUtils.resetFacesOnRenderer(renderer);
        }
        return true;
    }
}

