/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.power.BlockCapacitorBank;
import crazypants.enderio.machine.power.GaugeBounds;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.render.ConnectedTextureRenderer;
import crazypants.render.CustomCubeRenderer;
import crazypants.render.CustomRenderBlocks;
import crazypants.render.IRenderFace;
import crazypants.render.IconUtil;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector4d;
import crazypants.vecmath.Vector4f;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class CapBankRenderer2
implements ISimpleBlockRenderingHandler {
    private static final BlockCoord DEFAULT_BC = new BlockCoord(0, 0, 0);
    private static final BlockCoord[] DEFAULT_MB = new BlockCoord[]{DEFAULT_BC};
    private static final double PIXEL_SIZE = 0.0625;
    private final List<IRenderFace> renderers = new ArrayList<IRenderFace>(2);
    private ConnectedTextureRenderer connectedTexRenderer = new ConnectedTextureRenderer();

    public CapBankRenderer2() {
        this.connectedTexRenderer.setMatchMeta(true);
        GaugueRenderer gaugeRenderer = new GaugueRenderer();
        this.renderers.add(this.connectedTexRenderer);
        this.renderers.add(gaugeRenderer);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank cb = (TileCapacitorBank)te;
            cb.energyAtLastRender = cb.getEnergyStored();
        }
        if ((meta = world.func_72805_g(x, y, z)) == 1) {
            this.connectedTexRenderer.setEdgeTexture(IconUtil.whiteTexture);
            this.connectedTexRenderer.setForceAllEdges(true);
        } else {
            this.connectedTexRenderer.setEdgeTexture(EnderIO.blockAlloySmelter.func_149733_h(3));
            this.connectedTexRenderer.setForceAllEdges(false);
        }
        CustomCubeRenderer.instance.renderBlock(world, block, x, y, z, this.renderers);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockCapacitorBank.renderId;
    }

    private class GaugueRenderer
    implements IRenderFace {
        private GaugueRenderer() {
        }

        @Override
        public void renderFace(CustomRenderBlocks rb, ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture, List<Vertex> refVertices, boolean translateToXyz) {
            TileEntity te = rb.field_147845_a.func_147438_o((int)x, (int)y, (int)z);
            if (!(te instanceof TileCapacitorBank)) {
                return;
            }
            TileCapacitorBank capBank = (TileCapacitorBank)te;
            List<GaugeBounds> gaugeBounds = null;
            gaugeBounds = capBank.getGaugeBounds();
            if (gaugeBounds == null || gaugeBounds.isEmpty()) {
                return;
            }
            for (GaugeBounds gb : gaugeBounds) {
                if (gb.face != face) continue;
                Tessellator tes = Tessellator.field_78398_a;
                tes.func_78372_c((float)x, (float)y, (float)z);
                int b = 0;
                Vector4f col = new Vector4f();
                int colCount = 0;
                for (Vertex v : refVertices) {
                    b += v.brightness;
                    if (v.color == null) continue;
                    ++colCount;
                    col.add(v.color);
                }
                if (b > 0) {
                    tes.func_78380_c(b /= 4);
                } else {
                    tes.func_78380_c(0xF00000);
                }
                if (colCount > 0) {
                    col.scale(0.25);
                    tes.func_78369_a(col.x, col.y, col.z, col.w);
                }
                this.renderGaugeOnFace(gb, EnderIO.blockCapacitorBank.overlayIcon, refVertices, x, y, z);
                this.renderFillBarOnFace(gb, EnderIO.blockCapacitorBank.fillBarIcon, capBank.getEnergyStoredRatio(), refVertices, x, y, z);
                capBank.lastRenderStoredRatio = capBank.getEnergyStoredRatio();
                tes.func_78372_c((float)(-x), (float)(-y), (float)(-z));
                return;
            }
        }

        private List<GaugeBounds> calculateGaugeBounds(BlockCoord me, BlockCoord[] mb) {
            ArrayList<GaugeBounds> res = new ArrayList<GaugeBounds>();
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                boolean isRight;
                if (face == ForgeDirection.UP || face == ForgeDirection.DOWN || !(isRight = this.isRightFace(me, mb, face))) continue;
                res.add(new GaugeBounds(me, mb, face));
            }
            return res;
        }

        private void renderGaugeOnFace(GaugeBounds gb, IIcon icon, List<Vertex> vertices, double x, double y, double z) {
            Tessellator tes = Tessellator.field_78398_a;
            Vector2f u = gb.getMinMaxU(icon);
            List<Vertex> corners = gb.bb.getCornersWithUvForFace(gb.face, u.x, u.y, icon.func_94206_g(), icon.func_94210_h());
            for (Vertex coord : corners) {
                coord.xyz.add(ForgeDirectionOffsets.offsetScaled(gb.face, 0.001f));
                Vector3d xyz = new Vector3d(coord.xyz);
                xyz.x += x;
                xyz.y += y;
                xyz.z += z;
                Vertex v = this.getClosestVertex(vertices, xyz);
                if (v != null) {
                    if (v.color != null) {
                        tes.func_78369_a(v.color.x, v.color.y, v.color.z, v.color.w);
                    } else {
                        tes.func_78386_a(0.7f, 0.7f, 0.7f);
                    }
                    if (v.brightness > 0) {
                        tes.func_78380_c(v.brightness);
                    }
                }
                if (coord.uv != null) {
                    tes.func_78374_a(coord.x(), coord.y(), coord.z(), (double)coord.u(), (double)coord.v());
                    continue;
                }
                tes.func_78374_a(coord.x(), coord.y(), coord.z(), 0.0, 0.0);
            }
        }

        private void renderFillBarOnFace(GaugeBounds gb, IIcon icon, double filledRatio, List<Vertex> vertices, double x, double y, double z) {
            int totalPixels;
            int targetPixelCount;
            int pixelsBellowFace = gb.vInfo.index < 2 ? gb.vInfo.index * GaugeBounds.VPos.BOTTOM.numFillPixels : GaugeBounds.VPos.BOTTOM.numFillPixels + GaugeBounds.VPos.MIDDLE.numFillPixels * (gb.vInfo.index - 1);
            if (pixelsBellowFace >= (targetPixelCount = (int)Math.max(0L, Math.round((double)(totalPixels = gb.vInfo.verticalHeight == 1 ? GaugeBounds.VPos.SINGLE_BLOCK.numFillPixels : GaugeBounds.VPos.BOTTOM.numFillPixels + GaugeBounds.VPos.TOP.numFillPixels + GaugeBounds.VPos.MIDDLE.numFillPixels * (gb.vInfo.verticalHeight - 2)) * filledRatio)))) {
                return;
            }
            GaugeBounds.VPos yPos = gb.vInfo.pos;
            int numPixelsLeft = targetPixelCount - pixelsBellowFace;
            int fillPixels = Math.min(numPixelsLeft, yPos.numFillPixels);
            double maxY = (double)yPos.fillOffset * 0.0625 + (double)fillPixels * 0.0625;
            float vWidth = icon.func_94210_h() - icon.func_94206_g();
            float maxV = icon.func_94206_g() + (float)maxY * vWidth;
            Tessellator tes = Tessellator.field_78398_a;
            Vector2f u = gb.getMinMaxU(icon);
            List<Vertex> corners = gb.bb.getCornersWithUvForFace(gb.face, u.x, u.y, icon.func_94206_g(), maxV);
            for (Vertex coord : corners) {
                coord.xyz.add(ForgeDirectionOffsets.offsetScaled(gb.face, 0.002f));
                Vector3d xyz = new Vector3d(coord.xyz);
                xyz.x += x;
                xyz.y += y;
                xyz.z += z;
                Vertex v = this.getClosestVertex(vertices, xyz);
                if (v != null) {
                    if (v.color != null) {
                        tes.func_78369_a(v.color.x, v.color.y, v.color.z, v.color.w);
                    } else {
                        tes.func_78386_a(0.7f, 0.7f, 0.7f);
                    }
                    if (v.brightness > 0) {
                        tes.func_78380_c(v.brightness);
                    }
                }
                if (coord.uv != null) {
                    tes.func_78374_a(coord.x(), Math.min(coord.y(), maxY), coord.z(), (double)coord.u(), (double)coord.v());
                    continue;
                }
                tes.func_78374_a(coord.x(), Math.min(coord.y(), maxY), coord.z(), 0.0, 0.0);
            }
        }

        private boolean isRightFace(BlockCoord me, BlockCoord[] mb, ForgeDirection dir) {
            int myRightVal;
            Vector4d uPlane = RenderUtil.getUPlaneForFace(dir);
            int max = myRightVal = (int)uPlane.x * me.x + (int)uPlane.y * me.y + (int)uPlane.z * me.z;
            for (BlockCoord bc : mb) {
                int val = (int)uPlane.x * bc.x + (int)uPlane.y * bc.y + (int)uPlane.z * bc.z;
                if (val <= max) continue;
                max = val;
            }
            return myRightVal == max;
        }

        private Vertex getClosestVertex(List<Vertex> vertices, Vector3d corner) {
            Vertex result = null;
            double d2 = Double.MAX_VALUE;
            for (Vertex v : vertices) {
                double tmp = corner.distanceSquared(v.xyz);
                if (!(tmp <= d2)) continue;
                result = v;
                d2 = tmp;
            }
            return result;
        }
    }
}

