/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectSourceHelper;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.visnet.VisNetHandler;
import tuhljin.automagy.api.nethermind.INetherRune;
import tuhljin.automagy.api.nethermind.RuneCategory;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.ModTileEntity;

public class TileEntityNethermind
extends ModTileEntity
implements IAspectContainer {
    public static int MIN_NONBASIC_RUNES_FOR_EXCLUSIVITY = 4;
    public static int TICKS_BEFORE_ALLOW_DISABLE = 10;
    public static int EERIE_SPREAD_CHANCE = 25;
    public static float SPEED_RUNE_MULTIPLIER = 0.075f;
    public static float MAX_SPEED_RUNES = 12.0f;
    public static int MIN_Y = 10;
    public static int VALIDITY_CHECK_FREQUENCY = 60;
    private int ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
    public Set<BlockCoord> nonbasicRunePos = new HashSet<BlockCoord>();
    public int numSpeedRunes = 0;
    public AspectList aspectsNeeded = new AspectList();
    public int currentRuneX;
    public int currentRuneY = -1;
    public int currentRuneZ;
    public int currentRuneType;
    public int ticksToConjure;
    public int poweredTime = 0;
    private int ticksEnabled;

    public AspectList getAspects() {
        return this.aspectsNeeded;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isEnabled()) {
                ++this.ticksEnabled;
                if (this.ticksSinceValidityCheck >= VALIDITY_CHECK_FREQUENCY) {
                    if (!this.mapStructure()) {
                        this.tryDisable();
                        return;
                    }
                } else {
                    ++this.ticksSinceValidityCheck;
                }
                int prevPower = this.poweredTime;
                if (this.poweredTime > 0) {
                    --this.poweredTime;
                }
                if (this.poweredTime < 1) {
                    int amt;
                    int n = amt = this.isEnabled() ? VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 1), (int)this.field_145849_e, (Aspect)Aspect.FIRE, (int)10) : 0;
                    if (amt > 0) {
                        this.poweredTime = amt;
                        if (prevPower < 1) {
                            this.markDirty(true);
                        } else {
                            this.markDirty(false);
                        }
                    } else if (prevPower > 0) {
                        this.markDirty(true);
                    }
                }
                if (this.poweredTime > 0) {
                    if (this.aspectsNeeded.visSize() == 0) {
                        --this.ticksToConjure;
                        if (this.ticksToConjure == 0) {
                            BlockCoord pos = this.findValidPosition();
                            if (pos != null) {
                                int z;
                                int x;
                                INetherRune rune = this.getCurrentRune(false);
                                if (rune == null) {
                                    this.ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
                                    return;
                                }
                                Block block = rune.blockCreated(this.currentRuneType);
                                if (block == null) {
                                    this.ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
                                    return;
                                }
                                this.field_145850_b.func_147465_d(pos.x, pos.y, pos.z, block, rune.blockCreatedMetadata(this.currentRuneType), 3);
                                this.field_145850_b.func_147460_e(pos.x, pos.y, pos.z, block);
                                MessageParticles.sendToClients(this.field_145850_b, pos.x, pos.y, pos.z, 0, 0, 0, (short)8);
                                if (this.field_145850_b.field_73011_w.field_76574_g != -1 && this.field_145850_b.field_73012_v.nextInt(100) < EERIE_SPREAD_CHANCE && !ThaumcraftExtension.isBiomeEerie(this.field_145850_b, x = this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(12) - this.field_145850_b.field_73012_v.nextInt(12), z = this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(12) - this.field_145850_b.field_73012_v.nextInt(12))) {
                                    ThaumcraftExtension.setBiomeToEerie(this.field_145850_b, x, z);
                                }
                            } else {
                                this.ticksToConjure = 60;
                            }
                        }
                        if (this.ticksToConjure < 1) {
                            this.setNextRune();
                        } else {
                            this.markDirty(false);
                        }
                    } else {
                        int n = Math.max(5 - this.numSpeedRunes, 1);
                        if (this.ticksEnabled % n == 0) {
                            for (Aspect a : this.aspectsNeeded.getAspects()) {
                                if (this.aspectsNeeded.getAmount(a) <= 0 || !AspectSourceHelper.drainEssentia((TileEntity)this, (Aspect)a, (ForgeDirection)ForgeDirection.UNKNOWN, (int)12)) continue;
                                this.aspectsNeeded.reduce(a, 1);
                                this.func_70296_d();
                                break;
                            }
                        }
                    }
                }
            }
        } else if (this.isEnabled()) {
            ++this.ticksEnabled;
            if (this.isConjuring() && this.ticksEnabled % 16 == 0 && this.field_145850_b.field_73012_v.nextBoolean()) {
                this.field_145850_b.func_72869_a("dripLava", (double)this.field_145851_c + 0.6, (double)this.field_145848_d - 0.02, (double)this.field_145849_e + 0.6, 0.0, 0.0, 0.0);
            }
        }
    }

    protected BlockCoord findValidPosition() {
        int z;
        int y;
        int x;
        int minX = this.field_145851_c - 4;
        int maxX = this.field_145851_c + 4;
        int minY = Math.max(this.field_145848_d - 11, 1);
        int maxY = Math.max(this.field_145848_d - 3, 1);
        int minZ = this.field_145849_e - 4;
        int maxZ = this.field_145849_e + 4;
        int attempt = 0;
        do {
            if (!this.field_145850_b.func_147437_c(x = TjUtil.randInt(this.field_145850_b.field_73012_v, minX, maxX), y = TjUtil.randInt(this.field_145850_b.field_73012_v, minY, maxY), z = TjUtil.randInt(this.field_145850_b.field_73012_v, minZ, maxZ))) continue;
            return new BlockCoord(x, y, z);
        } while (++attempt < 33);
        for (x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    if (!this.field_145850_b.func_147437_c(x, y, z)) continue;
                    return new BlockCoord(x, y, z);
                }
            }
        }
        return null;
    }

    public boolean mapStructure() {
        this.ticksSinceValidityCheck = 0;
        this.nonbasicRunePos.clear();
        this.numSpeedRunes = 0;
        return this.mapRuneAtOffset(-1, 0, -1) && this.mapRuneAtOffset(0, 0, -1) && this.mapRuneAtOffset(1, 0, -1) && this.mapRuneAtOffset(-1, 0, 0) && this.mapRuneAtOffset(1, 0, 0) && this.mapRuneAtOffset(-1, 0, 1) && this.mapRuneAtOffset(0, 0, 1) && this.mapRuneAtOffset(1, 0, 1) && this.mapRuneAtOffset(-2, 0, 0) && this.mapRuneAtOffset(-3, 0, 0) && this.mapRuneAtOffset(-3, -1, 0) && this.mapRuneAtOffset(2, 0, 0) && this.mapRuneAtOffset(3, 0, 0) && this.mapRuneAtOffset(3, -1, 0) && this.mapRuneAtOffset(0, 0, -2) && this.mapRuneAtOffset(0, 0, -3) && this.mapRuneAtOffset(0, -1, -3) && this.mapRuneAtOffset(0, 0, 2) && this.mapRuneAtOffset(0, 0, 3) && this.mapRuneAtOffset(0, -1, 3);
    }

    protected boolean mapRuneAtOffset(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x += this.field_145851_c, y += this.field_145848_d, z += this.field_145849_e);
        if (block instanceof INetherRune) {
            INetherRune rune = (INetherRune)block;
            int type = rune.getRuneType((IBlockAccess)this.field_145850_b, x, y, z);
            RuneCategory sr = rune.getRuneCategory(type);
            if (sr == RuneCategory.speed) {
                if ((float)this.numSpeedRunes < MAX_SPEED_RUNES) {
                    ++this.numSpeedRunes;
                }
            } else if (type >= 0) {
                this.nonbasicRunePos.add(new BlockCoord(x, y, z));
            }
            return true;
        }
        return false;
    }

    public boolean tryEnable() {
        if (this.field_145848_d >= MIN_Y && !this.isEnabled() && this.mapStructure()) {
            this.ticksEnabled = 0;
            this.ticksToConjure = -1;
            this.markDirty(false);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:craftstart", 1.0f, 1.0f);
            MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0, 0, (short)2);
            return true;
        }
        return false;
    }

    public boolean tryDisable() {
        if (this.isEnabled() && this.ticksEnabled > TICKS_BEFORE_ALLOW_DISABLE) {
            this.aspectsNeeded.aspects.clear();
            this.poweredTime = 0;
            this.markDirty(false);
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            this.deactivateRune(this.currentRuneX, this.currentRuneY, this.currentRuneZ);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:craftfail", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.func_145832_p() == 1;
    }

    public boolean isConjuring() {
        return this.poweredTime > 0 && this.ticksToConjure > 0 && this.isEnabled() && this.aspectsNeeded.visSize() == 0;
    }

    public Block getBlockConjuring() {
        INetherRune rune = this.getCurrentRune(false);
        return rune.blockCreated(this.currentRuneType);
    }

    public void activateRune() {
        Block block;
        if (this.currentRuneType >= 0 && this.currentRuneY >= 0 && (block = this.field_145850_b.func_147439_a(this.currentRuneX, this.currentRuneY, this.currentRuneZ)) instanceof INetherRune) {
            ((INetherRune)block).activateRune(this.field_145850_b, this.currentRuneX, this.currentRuneY, this.currentRuneZ, this.currentRuneType);
        }
    }

    public void deactivateRune(int x, int y, int z) {
        Block block;
        if (this.currentRuneType >= 0 && y >= 0 && (block = this.field_145850_b.func_147439_a(x, y, z)) instanceof INetherRune) {
            ((INetherRune)block).deactivateRune(this.field_145850_b, x, y, z, this.currentRuneType);
        }
    }

    public void setNextRune() {
        int r;
        int prevX = this.currentRuneX;
        int prevY = this.currentRuneY;
        int prevZ = this.currentRuneZ;
        this.aspectsNeeded.aspects.clear();
        int size = this.nonbasicRunePos.size();
        if (size < MIN_NONBASIC_RUNES_FOR_EXCLUSIVITY && (r = this.field_145850_b.field_73012_v.nextInt(MIN_NONBASIC_RUNES_FOR_EXCLUSIVITY)) + 1 > size) {
            this.deactivateRune(this.currentRuneX, this.currentRuneY, this.currentRuneZ);
            this.currentRuneY = -1;
            this.currentRuneType = ModBlocks.runedObsidian.getRandomBasicRuneType(this.field_145850_b.field_73012_v);
            this.ticksToConjure = this.getTicksToConjure(ModBlocks.runedObsidian, this.currentRuneType);
            this.aspectsNeeded = ModBlocks.runedObsidian.essentiaCostPerBlockCreated(this.currentRuneType).copy();
            this.func_70296_d();
            return;
        }
        int item = this.field_145850_b.field_73012_v.nextInt(size);
        int i = 0;
        for (BlockCoord bc : this.nonbasicRunePos) {
            if (i == item) {
                this.currentRuneX = bc.x;
                this.currentRuneY = bc.y;
                this.currentRuneZ = bc.z;
                INetherRune rune = this.getCurrentRune(true);
                if (rune == null) {
                    this.deactivateRune(prevX, prevY, prevZ);
                    this.ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
                    this.markDirty(false);
                    return;
                }
                this.currentRuneType = rune.getRuneType((IBlockAccess)this.field_145850_b, this.currentRuneX, this.currentRuneY, this.currentRuneZ);
                this.ticksToConjure = this.getTicksToConjure(rune, this.currentRuneType);
                AspectList aspects = rune.essentiaCostPerBlockCreated(this.currentRuneType);
                if (aspects == null) {
                    this.deactivateRune(prevX, prevY, prevZ);
                    this.ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
                    this.markDirty(false);
                    return;
                }
                this.aspectsNeeded = aspects.copy();
                this.func_70296_d();
                if (prevX != this.currentRuneX || prevY != this.currentRuneY || prevZ != this.currentRuneZ) {
                    this.deactivateRune(prevX, prevY, prevZ);
                    this.activateRune();
                }
                return;
            }
            ++i;
        }
    }

    private int getTicksToConjure(INetherRune rune, int runeType) {
        int ticksToConjure = rune.ticksUntilBlockCreated(runeType);
        if (ticksToConjure > 0) {
            int t = ticksToConjure;
            if (this.numSpeedRunes > 0) {
                float f = (float)ticksToConjure * SPEED_RUNE_MULTIPLIER * (float)this.numSpeedRunes;
                ticksToConjure = Math.max(Math.round((float)ticksToConjure - f), 1);
            }
        }
        return ticksToConjure;
    }

    public INetherRune getCurrentRune(boolean ignoreCurrentType) {
        if (!ignoreCurrentType && this.currentRuneType < 0) {
            return ModBlocks.runedObsidian;
        }
        Block block = this.field_145850_b.func_147439_a(this.currentRuneX, this.currentRuneY, this.currentRuneZ);
        if (block instanceof INetherRune) {
            return (INetherRune)block;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspectsNeeded.readFromNBT(nbttagcompound);
        this.currentRuneX = nbttagcompound.func_74762_e("currentRuneX");
        this.currentRuneY = nbttagcompound.func_74762_e("currentRuneY");
        this.currentRuneZ = nbttagcompound.func_74762_e("currentRuneZ");
        this.currentRuneType = nbttagcompound.func_74762_e("currentRuneType");
        this.ticksToConjure = nbttagcompound.func_74762_e("ticksToConjure");
        this.poweredTime = nbttagcompound.func_74762_e("poweredTime");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspectsNeeded.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("currentRuneX", this.currentRuneX);
        nbttagcompound.func_74768_a("currentRuneY", this.currentRuneY);
        nbttagcompound.func_74768_a("currentRuneZ", this.currentRuneZ);
        nbttagcompound.func_74768_a("currentRuneType", this.currentRuneType);
        nbttagcompound.func_74768_a("ticksToConjure", this.ticksToConjure);
        nbttagcompound.func_74768_a("poweredTime", this.poweredTime);
    }
}

