/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import openperipheral.addons.glasses.GlassesRenderingUtils;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.CallbackProperty;
import openperipheral.api.adapter.method.ScriptObject;
import org.lwjgl.opengl.GL11;

@ScriptObject
@AdapterSourceName(value="glasses_liquid")
public class LiquidIcon
extends Drawable {
    @CallbackProperty
    public short width;
    @CallbackProperty
    public short height;
    @CallbackProperty
    public String fluid;
    @CallbackProperty
    public float alpha = 1.0f;
    private IIcon fluidIcon;
    private int iconWidth;
    private int iconHeight;

    LiquidIcon() {
    }

    public LiquidIcon(short x, short y, short width, short height, String fluid) {
        super(x, y);
        this.width = width;
        this.height = height;
        this.fluid = fluid;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawContents(float partialTicks) {
        if (this.fluidIcon == null || this.iconWidth <= 0 || this.iconHeight <= 0) {
            return;
        }
        TextureManager render = FMLClientHandler.instance().getClient().field_71446_o;
        render.func_110577_a(TextureMap.field_110575_b);
        float xIterations = (float)this.width / (float)this.iconWidth;
        float yIterations = (float)this.height / (float)this.iconHeight;
        GL11.glEnable((int)3553);
        for (float xIteration = 0.0f; xIteration < xIterations; xIteration += 1.0f) {
            for (float yIteration = 0.0f; yIteration < yIterations; yIteration += 1.0f) {
                float xDrawSize = Math.min(xIterations - xIteration, 1.0f);
                float yDrawSize = Math.min(yIterations - yIteration, 1.0f);
                GlassesRenderingUtils.drawTexturedQuad(xIteration * (float)this.iconWidth, yIteration * (float)this.iconHeight, this.fluidIcon, xDrawSize * (float)this.iconWidth, yDrawSize * (float)this.iconHeight, xDrawSize, yDrawSize, this.alpha);
            }
        }
        GL11.glDisable((int)3553);
    }

    @Override
    public Drawable.Type getTypeEnum() {
        return Drawable.Type.LIQUID;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.alpha > 0.0f;
    }

    @Override
    protected void onUpdate() {
        this.fluidIcon = LiquidIcon.findFluidIcon(this.fluid);
        if (this.fluidIcon != null) {
            this.iconWidth = this.fluidIcon.func_94211_a();
            this.iconHeight = this.fluidIcon.func_94216_b();
        }
    }

    private static IIcon findFluidIcon(String fluid) {
        Fluid drawLiquid = FluidRegistry.getFluid((String)fluid);
        return drawLiquid != null ? drawLiquid.getFlowingIcon() : null;
    }
}

