/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.replacing;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.replacing.ReplacementLogic;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.IToolPart;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;

public class ModPartReplacement
extends ItemModifier {
    public ModPartReplacement() {
        super(new ItemStack[0], 0, "");
    }

    public boolean matches(ItemStack[] recipe, ItemStack input) {
        return this.canModify(input, recipe);
    }

    protected boolean canModify(ItemStack itemStack, ItemStack[] parts) {
        ToolRecipe recipe;
        if (!(itemStack.func_77973_b() instanceof ToolCore)) {
            return false;
        }
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Special")) {
            return false;
        }
        if (tags.func_74762_e("Damage") > 0) {
            return false;
        }
        if (Config.disableStoneTools) {
            if (tool.getHeadItem() != null && ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.HEAD) == 1) {
                return false;
            }
            if (tool.getHandleItem() != null && ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.HANDLE) == 1 && tool.getHandleItem() != TinkerWeaponry.bowstring && tool.getHandleItem() != TinkerWeaponry.partArrowShaft) {
                return false;
            }
            if (tool.getAccessoryItem() != null && ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.ACCESSORY) == 1 && tool.getAccessoryItem() != TinkerWeaponry.bowstring && tool.getAccessoryItem() != TinkerWeaponry.fletching) {
                return false;
            }
            if (tool.getExtraItem() != null && ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.EXTRA) == 1) {
                return false;
            }
        }
        if ((recipe = this.findRecipe(tool)) == null) {
            return false;
        }
        Item replacementPartItem = null;
        int partIndex = -1;
        ReplacementLogic.PartTypes partType = null;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            Item item = parts[i].func_77973_b();
            if (tool == TinkerWeaponry.arrowAmmo && (item == Items.field_151120_aE || item == Items.field_151072_bj || item == Items.field_151103_aS || item == Items.field_151055_y)) {
                item = TinkerWeaponry.partArrowShaft;
            }
            if (item == Items.field_151103_aS || item == Items.field_151055_y) {
                item = TinkerTools.toolRod;
            }
            if (!(item instanceof IToolPart)) {
                return false;
            }
            if (replacementPartItem != null) {
                return false;
            }
            if (recipe.validHead(item)) {
                partType = ReplacementLogic.PartTypes.HEAD;
            } else if (recipe.validHandle(item)) {
                partType = ReplacementLogic.PartTypes.HANDLE;
            } else if (recipe.validAccessory(item)) {
                partType = ReplacementLogic.PartTypes.ACCESSORY;
            } else if (recipe.validExtra(item)) {
                partType = ReplacementLogic.PartTypes.EXTRA;
            } else {
                return false;
            }
            replacementPartItem = item;
            partIndex = i;
        }
        if (replacementPartItem == null) {
            return false;
        }
        if (partIndex == -1) {
            return false;
        }
        int newMatId = ToolBuilder.instance.getMaterialID(parts[partIndex]);
        int oldMatId = ReplacementLogic.getToolPartMaterial(tags, partType);
        int modifiers = tags.func_74762_e("Modifiers");
        for (int i = partIndex; i > 0; --i) {
            partType = ReplacementLogic.detectAdditionalPartType(recipe, replacementPartItem, partType);
            oldMatId = ReplacementLogic.getToolPartMaterial(tags, partType);
        }
        if (partType == ReplacementLogic.PartTypes.HEAD && TConstructRegistry.getMaterial((int)newMatId).harvestLevel == 0 && LevelingLogic.hasBoostXp(tags)) {
            return false;
        }
        if (ReplacementLogic.hasExtraModifier(oldMatId)) {
            --modifiers;
        }
        if (ReplacementLogic.hasExtraModifier(newMatId)) {
            ++modifiers;
        }
        if (modifiers < 0) {
            return false;
        }
        return newMatId != oldMatId;
    }

    public void modify(ItemStack[] parts, ItemStack itemStack) {
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        ToolRecipe recipe = this.findRecipe(tool);
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        DynamicToolPart replacementPartItem = null;
        int partIndex = -1;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            replacementPartItem = parts[i].func_77973_b();
            partIndex = i;
        }
        if (tool == TinkerWeaponry.arrowAmmo && (replacementPartItem == Items.field_151120_aE || replacementPartItem == Items.field_151072_bj || replacementPartItem == Items.field_151103_aS || replacementPartItem == Items.field_151055_y)) {
            replacementPartItem = TinkerWeaponry.partArrowShaft;
        }
        if (replacementPartItem == Items.field_151103_aS || replacementPartItem == Items.field_151055_y) {
            replacementPartItem = TinkerTools.toolRod;
        }
        ReplacementLogic.PartTypes partType = ReplacementLogic.detectAdditionalPartType(recipe, (Item)replacementPartItem, null);
        for (int i = partIndex; i > 0; --i) {
            partType = ReplacementLogic.detectAdditionalPartType(recipe, (Item)replacementPartItem, partType);
        }
        ReplacementLogic.exchangeToolPart(tool, tags, partType, parts[partIndex], itemStack);
    }

    private ToolRecipe findRecipe(ToolCore tool) {
        ToolRecipe recipe = (ToolRecipe)ToolBuilder.instance.recipeList.get(tool.getToolName());
        if (recipe == null) {
            for (ToolRecipe r : ToolBuilder.instance.combos) {
                if (!r.getType().getClass().equals(tool.getClass())) continue;
                recipe = r;
                break;
            }
        }
        return recipe;
    }

    public void addMatchingEffect(ItemStack input) {
    }
}

