/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.config.ConfigBlocks;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.TileEntityThaumostaticPylon;
import tuhljin.automagy.tiles.TileEntityThaumostaticPylonBase;
import tuhljin.automagy.tiles.TileEntityThaumostaticRefuelerSpire;

public class TileEntityThaumostaticController
extends TileEntityThaumostaticPylonBase
implements IEssentiaTransport {
    public static final int ARMORSLOT_CHEST = 2;
    public static int MAX_STORED_ASPECT = 8;
    public static AspectList maxAspects = new AspectList().add(Aspect.ENERGY, MAX_STORED_ASPECT).add(Aspect.AIR, MAX_STORED_ASPECT).add(Aspect.FLIGHT, MAX_STORED_ASPECT);
    public static List<Aspect> drawAspects = Arrays.asList(Aspect.ENERGY, Aspect.AIR, Aspect.FLIGHT);
    public static int RANGE_STANDARD = 12;
    public static int RANGE_UPGRADE_PER_PYLON = 10;
    public static int TRANSFER_RATE_STANDARD = 20;
    public static int TRANSFER_AMT_STANDARD = 1;
    public static int TRANSFER_AMT_UPGRADED = 1;
    public static int PYLON_TRANSFER_RATE_BONUS = 2;
    public static int UPGRADING_ESSENTIA_CONSUME_RATE = 60;
    public AspectList aspects = new AspectList();
    public boolean active = false;
    public int spireY = -1;
    public int pylonCount = 0;
    public int timeRangeUp;
    public int timeRateUp;
    protected HashMap<ForgeDirection, Aspect> dirSuction = new HashMap();
    protected int nextDistribution = 0;

    public TileEntityThaumostaticController() {
        this.dirSuction.put(ForgeDirection.NORTH, Aspect.ENERGY);
        this.dirSuction.put(ForgeDirection.SOUTH, Aspect.ENERGY);
        this.dirSuction.put(ForgeDirection.WEST, Aspect.ENERGY);
        this.dirSuction.put(ForgeDirection.EAST, Aspect.ENERGY);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.active || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean changed = false;
        int prevEnergy = this.aspects.getAmount(Aspect.ENERGY);
        int prevAir = this.aspects.getAmount(Aspect.AIR);
        int prevFlight = this.aspects.getAmount(Aspect.FLIGHT);
        AspectList drawAspectsNow = null;
        for (Aspect aspect : drawAspects) {
            if (this.aspects.getAmount(aspect) >= MAX_STORED_ASPECT) continue;
            if (drawAspectsNow == null) {
                drawAspectsNow = new AspectList();
            }
            drawAspectsNow.add(aspect, 1);
        }
        if (drawAspectsNow != null) {
            ForgeDirection[] dirs;
            for (ForgeDirection dir : dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}) {
                ThaumcraftExtension.AspectWithAmount drawn = ThaumcraftExtension.drawEssentia((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir, drawAspectsNow, this.getSuctionAmount(dir));
                if (drawn == null) continue;
                this.aspects.add(drawn.aspect, drawn.amount);
                changed = true;
                if (this.aspects.getAmount(drawn.aspect) < MAX_STORED_ASPECT) continue;
                drawAspectsNow.remove(drawn.aspect);
                if (drawAspectsNow.size() < 1) break;
            }
        }
        int energyLeft = this.aspects.getAmount(Aspect.ENERGY);
        TileEntityThaumostaticRefuelerSpire tileEntityThaumostaticRefuelerSpire = this.getSpireTile();
        if (tileEntityThaumostaticRefuelerSpire != null && tileEntityThaumostaticRefuelerSpire.isPowered()) {
            int e;
            if (this.nextDistribution > 0) {
                --this.nextDistribution;
                changed = true;
            }
            if (this.nextDistribution == 0) {
                this.nextDistribution = TRANSFER_RATE_STANDARD;
                if (this.timeRateUp > 0) {
                    this.nextDistribution -= this.pylonCount * PYLON_TRANSFER_RATE_BONUS;
                }
                if (this.doPotentiaDistribution()) {
                    changed = true;
                    energyLeft = this.aspects.getAmount(Aspect.ENERGY);
                    tileEntityThaumostaticRefuelerSpire.doSparks();
                }
            }
            if (this.timeRangeUp > 0) {
                --this.timeRangeUp;
                changed = true;
            }
            if (this.timeRangeUp == 0 && energyLeft > 0 && (e = this.aspects.getAmount(Aspect.AIR)) > 0) {
                this.aspects.remove(Aspect.AIR, 1);
                this.timeRangeUp = UPGRADING_ESSENTIA_CONSUME_RATE;
                changed = true;
            }
            if (this.timeRateUp > 0) {
                --this.timeRateUp;
                changed = true;
            }
            if (this.timeRateUp == 0 && energyLeft > 0 && (e = this.aspects.getAmount(Aspect.FLIGHT)) > 0) {
                this.aspects.remove(Aspect.FLIGHT, 1);
                this.timeRateUp = UPGRADING_ESSENTIA_CONSUME_RATE;
                changed = true;
            }
        }
        if (changed) {
            if (prevEnergy != energyLeft || prevAir != this.aspects.getAmount(Aspect.AIR) || prevFlight != this.aspects.getAmount(Aspect.FLIGHT)) {
                this.markDirty(true);
            } else {
                this.markDirty(false);
            }
        }
    }

    public boolean doPotentiaDistribution() {
        int startEnergy = this.aspects.getAmount(Aspect.ENERGY);
        if (startEnergy < 1) {
            return false;
        }
        double range = this.timeRangeUp > 0 ? (double)(this.pylonCount * RANGE_UPGRADE_PER_PYLON) : (double)RANGE_STANDARD;
        ArrayList<EntityPlayer> playerList = TjUtil.getPlayersInRangeSquared(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.spireY + 0.5 - (double)this.pylonCount / 2.0, (double)this.field_145849_e + 0.5, range * range);
        if (playerList.size() > 0) {
            int maxAmt = this.timeRateUp > 0 ? TRANSFER_AMT_UPGRADED : TRANSFER_AMT_STANDARD;
            int energy = startEnergy;
            for (EntityPlayer player : playerList) {
                int amt;
                ThaumcraftExtension.EssentiaJarItemRef jar;
                ItemStack stackChest = player.field_71071_by.func_70440_f(2);
                if (stackChest == null || (jar = ThaumcraftExtension.getJarFromHarness(stackChest)) == null) continue;
                AspectList jarAspects = jar.getAspects();
                if (jarAspects == null) {
                    jarAspects = new AspectList();
                    amt = maxAmt;
                } else {
                    amt = Math.min(maxAmt, 64 - jarAspects.getAmount(Aspect.ENERGY));
                }
                if (amt > 0) {
                    if (amt > energy) {
                        amt = energy;
                    }
                    jar.setAspects(jarAspects.add(Aspect.ENERGY, amt));
                    energy -= amt;
                    player.field_71069_bz.func_75142_b();
                }
                if (energy >= 1) continue;
                break;
            }
            if (energy != startEnergy) {
                this.aspects.remove(Aspect.ENERGY, startEnergy - energy);
                return true;
            }
        }
        return false;
    }

    public Aspect switchSuction(ForgeDirection dir) {
        Aspect a = this.dirSuction.get(dir);
        int i = drawAspects.indexOf(a);
        if (++i >= drawAspects.size()) {
            i = 0;
        }
        a = drawAspects.get(i);
        this.dirSuction.put(dir, a);
        return a;
    }

    public boolean checkValidity() {
        int pylonsHere = 0;
        int y = this.field_145848_d - 1;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
        while (te instanceof TileEntityThaumostaticPylon) {
            ++pylonsHere;
            te = this.field_145850_b.func_147438_o(this.field_145851_c, --y, this.field_145849_e);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) != Blocks.field_150371_ca || this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) != 1) {
            return false;
        }
        y = this.field_145848_d + 1;
        te = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
        while (te instanceof TileEntityThaumostaticPylon) {
            ++pylonsHere;
            te = this.field_145850_b.func_147438_o(this.field_145851_c, ++y, this.field_145849_e);
        }
        if (pylonsHere < 2) {
            return false;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) != ConfigBlocks.blockCosmeticSolid || this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) != 4) {
            return false;
        }
        if (!this.field_145850_b.func_147437_c(this.field_145851_c, y + 1, this.field_145849_e) || !this.field_145850_b.func_72937_j(this.field_145851_c, y + 1, this.field_145849_e)) {
            return false;
        }
        this.pylonCount = Math.min(pylonsHere, 6);
        this.markDirty(false);
        return true;
    }

    public void activate() {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (te instanceof TileEntityThaumostaticPylon) {
            ((TileEntityThaumostaticPylon)te).activate(this.field_145848_d, false);
        }
        if ((te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) instanceof TileEntityThaumostaticPylon) {
            ((TileEntityThaumostaticPylon)te).activate(this.field_145848_d, true);
        }
        int y = this.field_145848_d + 1;
        while (this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) != ConfigBlocks.blockCosmeticSolid || this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) != 4) {
            if (++y <= 500) continue;
            FMLLog.log((Level)Level.ERROR, (String)"[Automagy]  Failed to place Spire block. Thaumium block unexpectedly went missing.", (Object[])new Object[0]);
            return;
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
        this.field_145850_b.func_147449_b(this.field_145851_c, y, this.field_145849_e, (Block)ModBlocks.thaumostaticSpire);
        MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, y, this.field_145849_e, 0, 0, 0, (short)0);
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)y + 0.5, (double)this.field_145849_e + 0.5, "dig.stone", 1.0f, 1.0f);
        this.field_145850_b.func_147465_d(this.field_145851_c, y + 1, this.field_145849_e, (Block)ModBlocks.thaumostaticSpire, 1, 3);
        this.spireY = y;
        this.active = true;
        this.nextDistribution = TRANSFER_RATE_STANDARD;
        this.func_70296_d();
    }

    @Override
    public void assureValidity() {
        if (this.active) {
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            int md = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if ((b == ModBlocks.thaumostaticPylon && md == 0 || b == Blocks.field_150371_ca && md == 1) && ((b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) == ModBlocks.thaumostaticPylon && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == 0 || b == ModBlocks.thaumostaticSpire)) {
                return;
            }
            this.deactivate();
        }
    }

    public void deactivate() {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.spireY, this.field_145849_e);
        if (b == ModBlocks.thaumostaticSpire) {
            MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, this.spireY, this.field_145849_e, 0, 0, 0, (short)0);
            b.func_149697_b(this.field_145850_b, this.field_145851_c, this.spireY, this.field_145849_e, 0, 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.spireY, this.field_145849_e);
        }
        this.spireY = -1;
        this.active = false;
        this.func_70296_d();
    }

    private TileEntityThaumostaticRefuelerSpire getSpireTile() {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.spireY, this.field_145849_e);
        if (te instanceof TileEntityThaumostaticRefuelerSpire) {
            return (TileEntityThaumostaticRefuelerSpire)te;
        }
        return null;
    }

    public AspectList getAspects() {
        return this.aspects;
    }

    @Override
    public AspectList getAspectsBase() {
        return maxAspects;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return drawAspects.contains(tag);
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        if (amount != 1 || !this.doesContainerAccept(tag)) {
            return amount;
        }
        if (this.aspects.getAmount(tag) < MAX_STORED_ASPECT) {
            this.aspects.add(tag, amount);
            this.func_70296_d();
            return 0;
        }
        return amount;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.active && tag != Aspect.WEATHER) {
            return false;
        }
        if (this.aspects.getAmount(tag) >= amount) {
            this.aspects.remove(tag, amount);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return this.aspects.getAmount(tag);
    }

    public boolean isConnectable(ForgeDirection face) {
        return face != ForgeDirection.UP && face != ForgeDirection.DOWN;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face != ForgeDirection.UP && face != ForgeDirection.DOWN;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return face != ForgeDirection.UP && face != ForgeDirection.DOWN;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return this.dirSuction.get(face);
    }

    public int getSuctionAmount(ForgeDirection face) {
        return this.active && this.aspects.getAmount(this.getSuctionType(face)) < MAX_STORED_ASPECT ? 128 : 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canOutputTo(face) && this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canInputFrom(face) ? amount - this.addToContainer(aspect, amount) : 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        if (this.active) {
            if (this.aspects.getAmount(Aspect.WEATHER) > 0) {
                return Aspect.WEATHER;
            }
            return null;
        }
        return this.aspects.size() > 0 ? this.aspects.getAspects()[this.field_145850_b.field_73012_v.nextInt(this.aspects.getAspects().length)] : null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.active ? this.aspects.getAmount(Aspect.WEATHER) : this.aspects.visSize();
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.readFromNBT(nbttagcompound);
        this.active = nbttagcompound.func_74767_n("active");
        this.spireY = nbttagcompound.func_74762_e("spireY");
        this.pylonCount = nbttagcompound.func_74762_e("pylonCount");
        this.timeRangeUp = nbttagcompound.func_74762_e("timeRangeUp");
        this.timeRateUp = nbttagcompound.func_74762_e("timeRateUp");
        this.nextDistribution = nbttagcompound.func_74762_e("nextDistribution");
        String tag = nbttagcompound.func_74779_i("suctionN");
        if (!tag.isEmpty()) {
            this.dirSuction.put(ForgeDirection.NORTH, Aspect.getAspect((String)tag));
        }
        if (!(tag = nbttagcompound.func_74779_i("suctionS")).isEmpty()) {
            this.dirSuction.put(ForgeDirection.SOUTH, Aspect.getAspect((String)tag));
        }
        if (!(tag = nbttagcompound.func_74779_i("suctionW")).isEmpty()) {
            this.dirSuction.put(ForgeDirection.WEST, Aspect.getAspect((String)tag));
        }
        if (!(tag = nbttagcompound.func_74779_i("suctionE")).isEmpty()) {
            this.dirSuction.put(ForgeDirection.EAST, Aspect.getAspect((String)tag));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("active", this.active);
        nbttagcompound.func_74768_a("spireY", this.spireY);
        nbttagcompound.func_74768_a("pylonCount", this.pylonCount);
        nbttagcompound.func_74768_a("timeRangeUp", this.timeRangeUp);
        nbttagcompound.func_74768_a("timeRateUp", this.timeRateUp);
        nbttagcompound.func_74768_a("nextDistribution", this.nextDistribution);
        nbttagcompound.func_74778_a("suctionN", this.dirSuction.get(ForgeDirection.NORTH).getTag());
        nbttagcompound.func_74778_a("suctionS", this.dirSuction.get(ForgeDirection.SOUTH).getTag());
        nbttagcompound.func_74778_a("suctionW", this.dirSuction.get(ForgeDirection.WEST).getTag());
        nbttagcompound.func_74778_a("suctionE", this.dirSuction.get(ForgeDirection.EAST).getTag());
    }
}

