/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockValidationException;
import io.endertech.multiblock.controller.ControllerTank;
import io.endertech.multiblock.tile.TileTankPart;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTankValve
extends TileTankPart
implements IFluidHandler {
    public static final int ENERGY_PER_UNIT = 1;

    public static void init() {
        GameRegistry.registerTileEntity(TileTankValve.class, (String)"tile.endertech.enderTankValve");
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException("Tank valves cannot be used for tank interior.");
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canInteractFromDirection(from) || !this.isConnected()) {
            return 0;
        }
        ControllerTank controller = this.getTankController();
        int energyRequired = resource.amount * 1;
        int maxEnergyLimiter = controller.extractEnergy(from, energyRequired, true);
        int energyLimitedFill = (int)Math.floor((double)maxEnergyLimiter * 1.0 / 1.0);
        FluidStack resourceCopy = resource.copy();
        resourceCopy.amount = energyLimitedFill;
        int fillAmount = controller.tank.fill(resourceCopy, doFill);
        if (fillAmount > 0) {
            controller.extractEnergy(from, fillAmount * 1, false);
        }
        return fillAmount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canInteractFromDirection(from) || !this.canDrain(from, null)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int energyRequired;
        if (!this.canInteractFromDirection(from) || !this.canDrain(from, null)) {
            return null;
        }
        ControllerTank controller = this.getTankController();
        int maxEnergyLimiter = controller.extractEnergy(from, energyRequired = maxDrain * 1, true);
        int energyLimitedDrain = (int)Math.floor((double)maxEnergyLimiter * 1.0 / 1.0);
        FluidStack drained = controller.tank.drain(energyLimitedDrain, doDrain);
        if (drained != null && drained.amount > 0 && doDrain) {
            controller.extractEnergy(from, drained.amount * 1, false);
        }
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canInteractFromDirection(from);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canInteractFromDirection(from);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.canInteractFromDirection(from)) {
            return null;
        }
        return new FluidTankInfo[]{this.getTankController().tank.getInfo()};
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this.updateOutwardNeighbours();
    }

    @Override
    public void onMachineBroken() {
        this.updateOutwardNeighbours();
        super.onMachineBroken();
    }
}

