/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.render.block;

import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.IconTransformation;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Scale;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class RedNetCableRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    protected static CCModel base;
    protected static CCModel cage;
    protected static CCModel[] cable;
    protected static CCModel[] iface;
    protected static CCModel[] band;
    protected static CCModel[] plate;
    protected static CCModel[] platef;
    protected static CCModel[] grip;
    protected static CCModel[] wire;
    protected static CCModel[] caps;
    public static IconTransformation uvt;
    public static boolean brightBand;
    private ForgeDirection[] dirs = ForgeDirection.VALID_DIRECTIONS;

    private static void calculateSidedModels(CCModel[] cCModelArray, Vector3 vector3) {
        cCModelArray[4] = cCModelArray[5].copy().apply((Transformation)new Rotation(Math.PI, 0.0, 1.0, 0.0));
        RedNetCableRenderer.compute(cCModelArray[4]);
        cCModelArray[3] = cCModelArray[5].copy().apply((Transformation)new Rotation(-1.5707963267948966, 0.0, 1.0, 0.0));
        RedNetCableRenderer.compute(cCModelArray[3]);
        cCModelArray[2] = cCModelArray[5].copy().apply((Transformation)new Rotation(1.5707963267948966, 0.0, 1.0, 0.0));
        RedNetCableRenderer.compute(cCModelArray[2]);
        cCModelArray[1] = cCModelArray[5].copy().apply((Transformation)new Rotation(1.5707963267948966, 0.0, 0.0, 1.0).with((Transformation)new Rotation(Math.PI, 0.0, 1.0, 0.0)));
        RedNetCableRenderer.compute(cCModelArray[1]);
        cCModelArray[0] = cCModelArray[5].copy().apply((Transformation)new Rotation(-1.5707963267948966, 0.0, 0.0, 1.0));
        RedNetCableRenderer.compute(cCModelArray[0]);
        RedNetCableRenderer.compute(cCModelArray[5]);
    }

    private static void compute(CCModel cCModel) {
        cCModel.apply((Transformation)new Translation(0.5, 0.5, 0.5));
        cCModel.computeNormals();
        cCModel.computeLighting(LightModel.standardLightModel);
        cCModel.shrinkUVs(9.765625E-4);
    }

    public static void updateUVT(IIcon iIcon) {
        uvt = new IconTransformation(iIcon);
        brightBand = MFRConfig.brightRednetBand.getBoolean(true);
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        CCRenderState.reset();
        CCRenderState.useNormals = true;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        base.render(new CCRenderState.IVertexOperation[]{uvt});
        cable[2].render(new CCRenderState.IVertexOperation[]{uvt});
        cable[3].render(new CCRenderState.IVertexOperation[]{uvt});
        if (n == 3 | n == 2) {
            cage.render(new CCRenderState.IVertexOperation[]{uvt});
            wire[2].render(new CCRenderState.IVertexOperation[]{uvt});
            wire[3].render(new CCRenderState.IVertexOperation[]{uvt});
            caps[2].render(new CCRenderState.IVertexOperation[]{uvt});
            caps[3].render(new CCRenderState.IVertexOperation[]{uvt});
        }
        tessellator.func_78381_a();
    }

    public void func_147500_a(TileEntity tileEntity, double d, double d2, double d3, float f) {
        TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
        if (textureManager != null) {
            textureManager.func_110577_a(RenderHelper.MC_BLOCK_SHEET);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)d, (double)d2, (double)d3);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        World world = tileEntity.func_145831_w();
        int n = tileEntity.field_145851_c;
        int n2 = tileEntity.field_145848_d;
        int n3 = tileEntity.field_145849_e;
        int n4 = world.func_147439_a(n, n2, n3).func_149677_c((IBlockAccess)world, n, n2, n3);
        Tessellator.field_78398_a.func_78382_b();
        this.renderCable((IBlockAccess)world, 0, 0, 0, n4, (TileEntityRedNetCable)tileEntity);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)iBlockAccess.func_147438_o(n, n2, n3);
        if (MFRConfig.TESRCables && tileEntityRedNetCable.onRender()) {
            return false;
        }
        int n5 = block.func_149677_c(iBlockAccess, n, n2, n3);
        return this.renderCable(iBlockAccess, n, n2, n3, n5, tileEntityRedNetCable);
    }

    private boolean renderCable(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, TileEntityRedNetCable tileEntityRedNetCable) {
        CCRenderState.reset();
        CCRenderState.useNormals = false;
        TileEntityRedNetEnergy tileEntityRedNetEnergy = null;
        int n5 = brightBand ? 0xD00070 : n4;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78380_c(n4);
        if ((n | n2 | n3) != 0) {
            tessellator.func_78372_c((float)n, (float)n2, (float)n3);
        }
        base.render(new CCRenderState.IVertexOperation[]{uvt});
        if (tileEntityRedNetCable instanceof TileEntityRedNetEnergy) {
            cage.render(new CCRenderState.IVertexOperation[]{uvt});
            tileEntityRedNetEnergy = (TileEntityRedNetEnergy)tileEntityRedNetCable;
        }
        ForgeDirection[] forgeDirectionArray = this.dirs;
        int n6 = forgeDirectionArray.length;
        while (n6-- > 0) {
            ForgeDirection forgeDirection = forgeDirectionArray[n6];
            int n7 = forgeDirection.ordinal();
            RedNetConnectionType redNetConnectionType = tileEntityRedNetCable.getCachedConnectionState(forgeDirection);
            switch (redNetConnectionType.flags & 0x1F) {
                case 11: {
                    tessellator.func_78380_c(n5);
                    band[n7].setColour(tileEntityRedNetCable.getSideColorValue(forgeDirection));
                    band[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    tessellator.func_78380_c(n4);
                }
                case 19: {
                    if (redNetConnectionType.isSingleSubnet) {
                        iface[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                        grip[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                        break;
                    }
                    cable[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    break;
                }
                case 13: {
                    tessellator.func_78380_c(n5);
                    band[n7].setColour(tileEntityRedNetCable.getSideColorValue(forgeDirection));
                    band[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    platef[n7].setColour(tileEntityRedNetCable.getSideColorValue(forgeDirection));
                    platef[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
                    tessellator.func_78380_c(n4);
                }
                case 21: {
                    iface[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    plate[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                    if (!redNetConnectionType.isAllSubnets) break;
                    platef[n7].setColour(-1);
                    platef[n7].render(new CCRenderState.IVertexOperation[]{uvt});
                }
            }
            if (tileEntityRedNetEnergy == null || !tileEntityRedNetEnergy.isInterfacing(forgeDirection)) continue;
            wire[n7].render(new CCRenderState.IVertexOperation[]{uvt});
            if (tileEntityRedNetEnergy.interfaceMode(forgeDirection) == 4) continue;
            caps[n7].render(new CCRenderState.IVertexOperation[]{uvt});
        }
        if ((n | n2 | n3) != 0) {
            tessellator.func_78372_c((float)(-n), (float)(-n2), (float)(-n3));
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int n) {
        return true;
    }

    public int getRenderId() {
        return MineFactoryReloadedCore.renderIdRedNet;
    }

    static {
        cable = new CCModel[6];
        iface = new CCModel[6];
        band = new CCModel[6];
        plate = new CCModel[6];
        platef = new CCModel[6];
        grip = new CCModel[6];
        wire = new CCModel[6];
        caps = new CCModel[6];
        try {
            Map map = CCModel.parseObjModels((InputStream)MineFactoryReloadedCore.class.getResourceAsStream("/powercrystals/minefactoryreloaded/models/RedNetCable.obj"), (int)7, (Transformation)new Scale(0.0625));
            Vector3 vector3 = new Vector3(0.0, 0.0, 0.0);
            base = ((CCModel)map.get("base")).backfacedCopy();
            RedNetCableRenderer.compute(base);
            cage = ((CCModel)map.get("cage")).backfacedCopy();
            RedNetCableRenderer.compute(cage);
            RedNetCableRenderer.cable[5] = ((CCModel)map.get("cable")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(cable, vector3);
            RedNetCableRenderer.iface[5] = ((CCModel)map.get("interface")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(iface, vector3);
            RedNetCableRenderer.band[5] = ((CCModel)map.get("band")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(band, vector3);
            RedNetCableRenderer.plate[5] = ((CCModel)map.get("plate")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(plate, vector3);
            RedNetCableRenderer.platef[5] = ((CCModel)map.get("plateface")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(platef, vector3);
            RedNetCableRenderer.grip[5] = ((CCModel)map.get("grip")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(grip, vector3);
            RedNetCableRenderer.wire[5] = ((CCModel)map.get("wire")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(wire, vector3);
            RedNetCableRenderer.caps[5] = ((CCModel)map.get("cap")).backfacedCopy();
            RedNetCableRenderer.calculateSidedModels(caps, vector3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

