/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.IoConfigRenderer;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.gui.ToggleButtonEIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.gui.GuiOverlayIoConfig;
import crazypants.gui.GuiContainerBase;
import crazypants.gui.GuiToolTip;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import crazypants.vecmath.Vector4f;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public abstract class GuiMachineBase<T extends AbstractMachineEntity>
extends GuiContainerBase {
    public static final Vector4f PUSH_COLOR = new Vector4f(0.8f, 0.4f, 0.1f, 0.5f);
    public static final Vector4f PULL_COLOR = new Vector4f(0.1f, 0.4f, 0.8f, 0.5f);
    public static final int BUTTON_SIZE = 16;
    private static final int CONFIG_ID = 8962349;
    private static final int RECIPE_ID = 8962350;
    private final T tileEntity;
    protected RedstoneModeButton redstoneButton;
    private final GuiOverlayIoConfig configOverlay;
    protected ToggleButtonEIO configB;
    protected IconButtonEIO recipeButton;
    protected List<GuiToolTip> progressTooltips;
    protected int lastProgressTooltipValue = -1;

    protected GuiMachineBase(T machine, Container par1Container) {
        super(par1Container);
        this.tileEntity = machine;
        this.field_146999_f = this.getXSize();
        this.field_147000_g = this.getYSize();
        int x = this.getXSize() - 5 - 16;
        int y = 5;
        this.redstoneButton = new RedstoneModeButton(this, -1, x, y, (IRedstoneModeControlable)this.tileEntity, new BlockCoord((TileEntity)this.tileEntity));
        this.configB = new ToggleButtonEIO(this, 8962349, x, y += 19, IconEIO.IO_CONFIG_UP, IconEIO.IO_CONFIG_DOWN);
        this.configB.setToolTip(Lang.localize("gui.machine.ioMode.overlay.tooltip"));
        this.configOverlay = new GuiOverlayIoConfig((IIoConfigurable)machine){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                GuiMachineBase.this.configB.setSelected(visible);
            }
        };
        this.addOverlay(this.configOverlay);
        this.recipeButton = new IconButtonEIO(this, 8962350, x, y += 19, IconEIO.RECIPE);
        this.recipeButton.field_146125_m = false;
        this.recipeButton.setIconMargin(3, 3);
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 8962349) {
            boolean vis = !this.configOverlay.isVisible();
            this.configOverlay.setVisible(vis);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneButton.onGuiInit();
        this.configB.onGuiInit();
        this.recipeButton.onGuiInit();
    }

    protected boolean showRecipeButton() {
        return EnderIO.proxy.isNeiInstalled();
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.showRecipeButton()) {
            this.recipeButton.field_146125_m = true;
        }
        this.renderSlotHighlights();
    }

    public void renderSlotHighlights() {
        IoMode mode;
        IoConfigRenderer.SelectedFace sel = this.configOverlay.getSelection();
        if (sel != null && (mode = sel.config.getIoMode(sel.face)) != null) {
            this.renderSlotHighlights(mode);
        }
    }

    public void renderSlotHighlights(IoMode mode) {
        int slot;
        SlotDefinition slotDef = ((AbstractMachineEntity)this.tileEntity).getSlotDefinition();
        if (slotDef.getNumInputSlots() > 0 && (mode == IoMode.PULL || mode == IoMode.PUSH_PULL)) {
            for (slot = slotDef.getMinInputSlot(); slot <= slotDef.getMaxInputSlot(); ++slot) {
                this.renderSlotHighlight(slot, PULL_COLOR);
            }
        }
        if (slotDef.getNumOutputSlots() > 0 && (mode == IoMode.PUSH || mode == IoMode.PUSH_PULL)) {
            for (slot = slotDef.getMinOutputSlot(); slot <= slotDef.getMaxOutputSlot(); ++slot) {
                this.renderSlotHighlight(slot, PUSH_COLOR);
            }
        }
    }

    protected void renderSlotHighlight(int slot, Vector4f col) {
        Slot invSlot = (Slot)this.field_147002_h.field_75151_b.get(slot);
        this.renderSlotHighlight(col, invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSlotHighlight(Vector4f col, int x, int y, int width, int height) {
        GL11.glEnable((int)3042);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), 0.0, (double)width, (double)height, col);
        GL11.glDisable((int)3042);
    }

    protected boolean isConfigOverlayEnabled() {
        return this.configOverlay.isVisible();
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected void addProgressTooltip(int x, int y, int w, int h) {
        if (this.progressTooltips == null) {
            this.progressTooltips = new ArrayList<GuiToolTip>();
        }
        GuiToolTip tt = new GuiToolTip(new Rectangle(x, y, w, h), (String[])null);
        this.progressTooltips.add(tt);
        this.addToolTip(tt);
    }

    private void updateProgressTooltips(int progress) {
        if (this.lastProgressTooltipValue == progress || this.progressTooltips == null) {
            return;
        }
        this.lastProgressTooltipValue = progress;
        if (progress < 0) {
            for (GuiToolTip tt : this.progressTooltips) {
                tt.setVisible(false);
            }
            return;
        }
        String msg = MessageFormat.format(Lang.localize("gui.progress"), progress);
        for (GuiToolTip tt : this.progressTooltips) {
            tt.setToolTipText(msg);
            tt.setVisible(true);
        }
    }

    protected boolean shouldRenderProgress() {
        float progress = ((AbstractMachineEntity)this.tileEntity).getProgress();
        if (progress > 0.0f && progress < 1.0f) {
            this.updateProgressTooltips((int)(progress * 100.0f));
            return true;
        }
        this.updateProgressTooltips(-1);
        return false;
    }
}

