/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client;

import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import kihira.tails.client.model.ears.ModelCatEars;
import kihira.tails.client.model.ears.ModelFoxEars;
import kihira.tails.client.model.ears.ModelPandaEars;
import kihira.tails.client.model.tail.ModelBirdTail;
import kihira.tails.client.model.tail.ModelCatTail;
import kihira.tails.client.model.tail.ModelDevilTail;
import kihira.tails.client.model.tail.ModelDragonTail;
import kihira.tails.client.model.tail.ModelFluffyTail;
import kihira.tails.client.model.tail.ModelRaccoonTail;
import kihira.tails.client.render.RenderPart;
import kihira.tails.client.render.RenderWings;
import kihira.tails.common.PartsData;

@SideOnly(value=Side.CLIENT)
public class PartRegistry {
    private static final ArrayListMultimap<PartsData.PartType, RenderPart> partRegistry = ArrayListMultimap.create();

    public static void registerPart(PartsData.PartType partType, RenderPart renderPart) {
        partRegistry.put((Object)partType, (Object)renderPart);
    }

    public static List<RenderPart> getParts(PartsData.PartType partType) {
        return partRegistry.get((Object)partType);
    }

    public static RenderPart getRenderPart(PartsData.PartType partType, int index) {
        List<RenderPart> parts = PartRegistry.getParts(partType);
        index = index >= parts.size() ? 0 : index;
        return parts.get(index);
    }

    static {
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.fluffy", 2, null, new ModelFluffyTail(), "foxTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.dragon", 1, null, new ModelDragonTail(), "dragonTail", "dragonTailStriped").setAuthor("@TTFTCUTS", 0, 0).setAuthor("@TTFTCUTS", 1, 0));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.raccoon", 0, null, new ModelRaccoonTail(), "racoonTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.devil", 1, null, new ModelDevilTail(), "devilTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.cat", 0, null, new ModelCatTail(), "tabbyTail", "tigerTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.bird", 0, null, new ModelBirdTail(), "birdTail").setAuthor("@blusunrize", 0, 0));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.fox", 0, "@Adeon", new ModelFoxEars(), "foxEars"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.cat", 0, null, new ModelCatEars(), "catEars"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.panda", 0, null, new ModelPandaEars(), "pandaEars"));
        PartRegistry.registerPart(PartsData.PartType.WINGS, new RenderWings("wings.big", 1, "@littlechippie", null, "bigWings", "metalWings").setAuthor("@littlechippie"));
    }
}

