/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.block.RotationAxis;

public enum BlockRotationMode {
    NONE(RotationAxis.NO_AXIS, 0, new ForgeDirection[0]){

        @Override
        public boolean isValid(ForgeDirection dir) {
            return true;
        }

        @Override
        public ForgeDirection fromValue(int value) {
            return ForgeDirection.UNKNOWN;
        }

        @Override
        public int toValue(ForgeDirection dir) {
            return 0;
        }
    }
    ,
    TWO_DIRECTIONS(RotationAxis.SINGLE_AXIS, 1, new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.NORTH}){

        @Override
        public ForgeDirection fromValue(int value) {
            return (value & 1) == 0 ? ForgeDirection.WEST : ForgeDirection.NORTH;
        }

        @Override
        public int toValue(ForgeDirection dir) {
            switch (dir) {
                case WEST: 
                case EAST: {
                    return 0;
                }
                case NORTH: 
                case SOUTH: {
                    return 1;
                }
            }
            throw new IllegalArgumentException(dir.name());
        }
    }
    ,
    FOUR_DIRECTIONS(RotationAxis.SINGLE_AXIS, 2, new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}){

        @Override
        public ForgeDirection fromValue(int value) {
            switch (value & 3) {
                case 0: {
                    return ForgeDirection.NORTH;
                }
                case 1: {
                    return ForgeDirection.WEST;
                }
                case 2: {
                    return ForgeDirection.SOUTH;
                }
                case 3: {
                    return ForgeDirection.EAST;
                }
            }
            return ForgeDirection.UNKNOWN;
        }

        @Override
        public int toValue(ForgeDirection dir) {
            switch (dir) {
                case NORTH: {
                    return 0;
                }
                case WEST: {
                    return 1;
                }
                case SOUTH: {
                    return 2;
                }
                case EAST: {
                    return 3;
                }
            }
            throw new IllegalArgumentException(dir.name());
        }
    }
    ,
    SIX_DIRECTIONS(RotationAxis.THREE_AXIS, 3, ForgeDirection.VALID_DIRECTIONS){

        @Override
        public ForgeDirection fromValue(int value) {
            return ForgeDirection.getOrientation((int)(value & 7));
        }

        @Override
        public int toValue(ForgeDirection dir) {
            return dir.ordinal();
        }
    };

    public final ForgeDirection[] rotations;
    private final Set<ForgeDirection> allowedDirections;
    public final int bitCount;
    public final int mask;

    private BlockRotationMode(ForgeDirection[] rotations, int bitCount, ForgeDirection ... allowedDirections) {
        this.rotations = rotations;
        this.allowedDirections = ImmutableSet.copyOf((Object[])allowedDirections);
        this.bitCount = bitCount;
        this.mask = (1 << bitCount) - 1;
    }

    public boolean isValid(ForgeDirection dir) {
        return this.allowedDirections.contains(dir);
    }

    public abstract ForgeDirection fromValue(int var1);

    public abstract int toValue(ForgeDirection var1);
}

