/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.weapons;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.weapons.BowHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.InfoHelper;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.brandon3055.draconicevolution.common.utills.ItemNBTHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class DraconicBow
extends ItemBow
implements IInventoryTool {
    public static final String[] bowPullIconNameArray = new String[]{"pulling_0", "pulling_1", "pulling_2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public DraconicBow() {
        this.field_77777_bU = 1;
        this.func_77656_e(-1);
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
        this.func_77655_b("draconicBow");
        if (ModItems.isEnabled((Item)this)) {
            GameRegistry.registerItem((Item)this, (String)"draconicBow");
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            ArrowNockEvent event = new ArrowNockEvent(player, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return event.result;
            }
            if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(Items.field_151032_g) || player.field_71071_by.func_146028_b((Item)ModItems.enderArrow) || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0) {
                player.func_71008_a(stack, this.func_77626_a(stack));
            }
        } else {
            this.changeMode(stack, player);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        String currentMode = ItemNBTHelper.getString(stack, "mode", "rapidfire");
        if (player.field_71071_by.func_146028_b((Item)ModItems.enderArrow)) {
            currentMode = "ender";
        }
        if (currentMode.equals("rapidfire")) {
            BowHandler.rapidFire(player, count, 4);
        } else if (currentMode.equals("devistation")) {
            BowHandler.rapidFire(player, count, 2);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int count) {
        String currentMode = ItemNBTHelper.getString(stack, "mode", "rapidfire");
        if (player.field_71071_by.func_146028_b((Item)ModItems.enderArrow)) {
            currentMode = "ender";
        }
        if (currentMode.equals("rapidfire")) {
            BowHandler.standerdShot(stack, world, player, count, field_77697_d, 5.0f, 1.5f, true, 9.0, 1.0f, false, 0);
        } else if (currentMode.equals("sharpshooter")) {
            BowHandler.standerdShot(stack, world, player, count, field_77697_d, 21.0f, 5.0f, true, 30.0, 0.7f, false, 20);
        } else if (currentMode.equals("explosive")) {
            BowHandler.standerdShot(stack, world, player, count, field_77697_d, 5.0f, 0.5f, true, 0.0, 1.0f, true, 80);
        } else if (currentMode.equals("devistation")) {
            BowHandler.standerdShot(stack, world, player, count, field_77697_d, 2.0f, 2.0f, true, 0.0, 1.0f, true, 0);
        } else if (currentMode.equals("ender")) {
            BowHandler.enderShot(stack, world, player, count, field_77697_d, 21.0f, 1.5f, 1.0f, 0);
        }
    }

    public void changeMode(ItemStack stack, EntityPlayer player) {
        String currentMode = ItemNBTHelper.getString(stack, "mode", "rapidfire");
        if (currentMode.equals("rapidfire")) {
            ItemNBTHelper.setString(stack, "mode", "sharpshooter");
        } else if (currentMode.equals("sharpshooter")) {
            ItemNBTHelper.setString(stack, "mode", "explosive");
        } else if (currentMode.equals("explosive") && player.field_71075_bZ.field_75098_d) {
            ItemNBTHelper.setString(stack, "mode", "devistation");
        } else {
            ItemNBTHelper.setString(stack, "mode", "rapidfire");
        }
        if (player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.bowmode" + ItemNBTHelper.getString(stack, "mode", "rapidfire") + ".txt", new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_bow" + "_standby");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_bow" + "_" + bowPullIconNameArray[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        String currentMode = ItemNBTHelper.getString(stack, "mode", "rapidfire");
        if (player.field_71071_by.func_146028_b((Item)ModItems.enderArrow)) {
            currentMode = "sharpshooter";
        }
        int j = stack.func_77988_m() - useRemaining;
        if (usingItem == null) {
            return this.field_77791_bV;
        }
        if (currentMode.equals("rapidfire")) {
            if (j >= 4) {
                return this.func_94599_c(2);
            }
            if (j > 2) {
                return this.func_94599_c(1);
            }
            if (j > 0) {
                return this.func_94599_c(0);
            }
        } else if (currentMode.equals("devistation")) {
            if (j >= 2) {
                return this.func_94599_c(2);
            }
            if (j > 1) {
                return this.func_94599_c(1);
            }
            if (j > 0) {
                return this.func_94599_c(0);
            }
        } else if (currentMode.equals("sharpshooter")) {
            if (j >= 20) {
                return this.func_94599_c(2);
            }
            if (j > 10) {
                return this.func_94599_c(1);
            }
            if (j > 0) {
                return this.func_94599_c(0);
            }
        } else {
            if (j >= 80) {
                return this.func_94599_c(2);
            }
            if (j > 40) {
                return this.func_94599_c(1);
            }
            if (j > 0) {
                return this.func_94599_c(0);
            }
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_94599_c(int par1) {
        return this.iconArray[par1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInformation) {
        if (InfoHelper.holdShiftForDetails(list)) {
            list.add(StatCollector.func_74838_a((String)("msg.bowmode" + ItemNBTHelper.getString(stack, "mode", "rapidfire") + ".txt")));
            list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.bowEnchants.txt"));
            InfoHelper.addLore(stack, list);
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryEnch.txt");
    }

    @Override
    public int getInventorySlots() {
        return 0;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.bow || enchant.field_77352_x == DraconicEvolution.reaperEnchant.field_77352_x;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        return new ArrayList<ItemConfigField>();
    }
}

