/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.block.tileentity;

import com.cricketcraft.chisel.api.IChiselItem;
import com.cricketcraft.chisel.carving.Carving;
import com.cricketcraft.chisel.client.GeneralChiselClient;
import com.cricketcraft.chisel.init.ChiselItems;
import com.cricketcraft.chisel.network.PacketHandler;
import com.cricketcraft.chisel.network.message.MessageAutoChisel;
import com.cricketcraft.chisel.network.message.MessageSlotUpdate;
import com.cricketcraft.chisel.utils.General;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;

public class TileEntityAutoChisel
extends TileEntity
implements ISidedInventory {
    public static final int BASE = 0;
    public static final int TARGET = 1;
    public static final int OUTPUT = 2;
    public static final int CHISEL = 3;
    public static final int MIN_UPGRADE = 4;
    private static final int FAST_SPEED = 1;
    private static final int SLOW_SPEED = 4;
    private int progress = 0;
    private static EntityItem ghostItem;
    boolean equal = false;
    private ItemStack[] inventory = new ItemStack[7];
    private String name = "autoChisel";
    public float xRot;
    public float yRot;
    public float zRot;
    public static final int maxRot = 60;
    public static final int rotAmnt = 15;
    public float chiselRot;
    public boolean chiseling = false;
    public boolean breakChisel = false;
    public int toChisel = 1;
    private ItemStack lastBase;

    public boolean canUpdate() {
        return true;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= size) {
                ItemStack is = this.inventory[slot];
                this.inventory[slot] = null;
                return is;
            }
            ItemStack is = this.inventory[slot].func_77979_a(size);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return is;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList tags = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data = tags.func_150305_b(i);
            int j = data.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
        if (nbt.func_150297_b("CustomName", 8)) {
            this.name = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145845_h() {
        ItemStack base = this.inventory[0];
        ItemStack target = this.inventory[1];
        ItemStack output = this.inventory[2];
        if (!this.field_145850_b.field_72995_K && this.hasChisel() && base != null && target != null) {
            if (this.canBeMadeFrom(base, target)) {
                if (this.progress >= (this.hasUpgrade(Upgrade.SPEED) ? 1 : 4)) {
                    this.progress = 0;
                    int canBeMade = target.func_77976_d();
                    if (output != null) {
                        canBeMade -= output.field_77994_a;
                    }
                    if ((canBeMade = Math.min(base.field_77994_a, canBeMade)) <= 0) {
                        return;
                    }
                    ItemStack chiseled = target.func_77946_l();
                    int n = chiseled.field_77994_a = this.hasUpgrade(Upgrade.STACK) ? canBeMade : 1;
                    if (this.canChisel(chiseled)) {
                        if (output == null) {
                            this.func_70299_a(2, chiseled);
                        } else {
                            this.inventory[2].field_77994_a += chiseled.field_77994_a;
                            this.slotChanged(2);
                        }
                        this.chiselItem(chiseled.field_77994_a);
                        base.field_77994_a -= chiseled.field_77994_a;
                        if (base.field_77994_a <= 0) {
                            this.func_70299_a(0, null);
                        }
                    }
                } else if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                    ++this.progress;
                }
            }
        } else if (this.field_145850_b.field_72995_K) {
            if (this.chiseling) {
                this.chiselRot += 15.0f;
                if (this.chiselRot >= 60.0f) {
                    this.chiselItem(0);
                }
            } else {
                this.chiselRot = Math.max(this.chiselRot - 15.0f, 0.0f);
            }
        }
    }

    private boolean canBeMadeFrom(ItemStack from, ItemStack to) {
        List<ItemStack> results = Carving.chisel.getItemsForChiseling(from);
        for (ItemStack s : results) {
            if (s.func_77973_b() != to.func_77973_b() || s.func_77960_j() != to.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    private boolean canChisel(ItemStack toMerge) {
        if (this.inventory[2] == null) {
            return true;
        }
        if (toMerge.func_77969_a(this.inventory[2]) && ItemStack.func_77970_a((ItemStack)toMerge, (ItemStack)this.inventory[2])) {
            return !toMerge.func_77981_g() || toMerge.func_77960_j() == this.inventory[2].func_77960_j();
        }
        return ((IChiselItem)this.inventory[3].func_77973_b()).canChisel(this.field_145850_b, this.inventory[3], General.getVariation(this.inventory[1]));
    }

    private boolean hasChisel() {
        return this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IChiselItem && this.inventory[3].field_77994_a >= 1;
    }

    private void chiselItem(int chiseled) {
        if (!this.field_145850_b.field_72995_K) {
            boolean breakChisel = false;
            if (((IChiselItem)this.inventory[3].func_77973_b()).onChisel(this.field_145850_b, this.inventory[3], General.getVariation(this.inventory[1]))) {
                this.inventory[3].func_77964_b(this.inventory[3].func_77960_j() + 1);
                if (this.inventory[3].func_77960_j() >= this.inventory[3].func_77958_k()) {
                    this.func_70299_a(3, null);
                    breakChisel = true;
                }
            }
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageAutoChisel(this, chiseled, true, breakChisel), this.field_145850_b.field_73011_w.field_76574_g);
        } else {
            if (this.breakChisel) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.break", 0.8f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f, false);
            }
            GeneralChiselClient.spawnAutoChiselFX(this, this.lastBase != null ? this.lastBase : this.inventory[0]);
            this.chiseling = false;
            if (this.lastBase != null) {
                this.lastBase.field_77994_a -= this.toChisel;
                if (this.lastBase.field_77994_a <= 0) {
                    this.lastBase = null;
                }
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Items", (NBTBase)tags);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.name);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack is = this.inventory[slot];
            this.inventory[slot] = null;
            return is;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (this.field_145850_b.field_72995_K && slot == 0 && stack != null) {
            this.lastBase = stack.func_77946_l();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.slotChanged(slot);
        }
    }

    private void slotChanged(int slot) {
        PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageSlotUpdate(this, slot, this.inventory[slot]), this.field_145850_b.field_73011_w.field_76574_g);
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.name;
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        switch (slot) {
            case 0: 
            case 1: {
                return !Carving.chisel.getItemsForChiseling(itemStack).isEmpty();
            }
            case 2: {
                return false;
            }
            case 3: {
                return itemStack.func_77973_b() instanceof IChiselItem;
            }
        }
        return itemStack.func_77973_b() == ChiselItems.upgrade && Upgrade.values()[slot - 4].ordinal() == itemStack.func_77960_j();
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.hasUpgrade(Upgrade.AUTOMATION) && (slot == 0 || slot == 1 || slot == 3);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return this.hasUpgrade(Upgrade.AUTOMATION) && slot == 2;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @SideOnly(value=Side.CLIENT)
    public EntityItem getItemForRendering(int slot) {
        if (ghostItem == null) {
            ghostItem = new EntityItem(this.field_145850_b);
            TileEntityAutoChisel.ghostItem.field_70290_d = 0.0f;
        }
        if (slot == 0 && this.lastBase != null) {
            ghostItem.func_92058_a(this.lastBase.func_77946_l());
            return ghostItem;
        }
        if (this.inventory[slot] == null) {
            return null;
        }
        ghostItem.func_92058_a(this.inventory[slot].func_77946_l());
        return ghostItem;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean hasUpgrade(Upgrade upgrade) {
        ItemStack stack = this.inventory[4 + upgrade.ordinal()];
        if (stack != null) {
            return stack.func_77973_b() == ChiselItems.upgrade && stack.func_77960_j() == upgrade.ordinal();
        }
        return false;
    }

    public String getSlotTooltipUnloc(int slotNumber) {
        String base = "autochisel.slot.%s.tooltip";
        String name = null;
        if (slotNumber < 4) {
            if (slotNumber == 1) {
                name = "target";
            } else if (slotNumber == 3) {
                name = "chisel";
            }
            return name == null ? null : String.format(base, name);
        }
        return Upgrade.values()[slotNumber - 4].getUnlocalizedName() + ".name";
    }

    public void doChiselAnim(ItemStack lastChiseled, int chiseled, boolean playSound, boolean breakChisel) {
        this.lastBase = lastChiseled == null ? null : lastChiseled.func_77946_l();
        this.toChisel = chiseled;
        if (playSound) {
            this.chiseling = true;
        }
        this.breakChisel = breakChisel;
    }

    public ItemStack getLastBase() {
        return this.lastBase == null ? null : this.lastBase.func_77946_l();
    }

    public static enum Upgrade {
        SPEED,
        AUTOMATION,
        STACK;


        public String getUnlocalizedName() {
            return ChiselItems.upgrade.func_77658_a() + "_" + this.name().toLowerCase();
        }

        public String getLocalizedName() {
            return StatCollector.func_74838_a((String)(this.getUnlocalizedName() + ".name"));
        }
    }
}

