/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IGenericInboundTypeConverter;

public class ConverterMapInbound
implements IGenericInboundTypeConverter {
    private static final TypeVariable<?> KEY;
    private static final TypeVariable<?> VALUE;

    @Override
    public Object toJava(IConverter registry, Object obj, Type expected) {
        TypeToken type;
        if (obj instanceof Map && (type = TypeToken.of((Type)expected)).getRawType() == Map.class) {
            Type keyType = type.resolveType(KEY).getType();
            Type valueType = type.resolveType(VALUE).getType();
            HashMap result = Maps.newHashMap();
            for (Map.Entry e : ((Map)obj).entrySet()) {
                Object key = registry.toJava(e.getKey(), keyType);
                Object value = registry.toJava(e.getValue(), valueType);
                result.put(key, value);
            }
            return result;
        }
        return null;
    }

    static {
        TypeVariable<Class<T>>[] vars = Map.class.getTypeParameters();
        KEY = vars[0];
        VALUE = vars[1];
    }
}

