/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IGenericInboundTypeConverter;

public class ConverterListInbound
implements IGenericInboundTypeConverter {
    private static final TypeVariable<?> TYPE_PARAM = List.class.getTypeParameters()[0];

    @Override
    public Object toJava(IConverter registry, Object obj, Type expected) {
        TypeToken type;
        if (obj instanceof Map && (type = TypeToken.of((Type)expected)).getRawType() == List.class) {
            Type valueType = type.resolveType(TYPE_PARAM).getType();
            Map m = (Map)obj;
            if (m.isEmpty()) {
                return ImmutableList.of();
            }
            int indexMin = Integer.MAX_VALUE;
            int indexMax = Integer.MIN_VALUE;
            HashMap tmp = Maps.newHashMap();
            for (Map.Entry e : m.entrySet()) {
                Object k = e.getKey();
                if (!(k instanceof Number)) {
                    return null;
                }
                int index = ((Number)k).intValue();
                if (index < indexMin) {
                    indexMin = index;
                }
                if (index > indexMax) {
                    indexMax = index;
                }
                tmp.put(index, e.getValue());
            }
            if (indexMin != 0 && indexMin != 1) {
                return null;
            }
            ArrayList result = Lists.newArrayList();
            for (int index = indexMin; index <= indexMax; ++index) {
                Object o = tmp.get(index);
                Object converted = registry.toJava(o, valueType);
                result.add(converted);
            }
            return result;
        }
        return null;
    }
}

