/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.tc;

import appeng.api.config.Actionable;
import appeng.api.storage.data.IAEFluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.common.tiles.TileAlchemyFurnaceAdvancedNozzle;
import thaumcraft.common.tiles.TileAlembic;
import thaumcraft.common.tiles.TileCentrifuge;
import thaumcraft.common.tiles.TileEssentiaReservoir;
import thaumcraft.common.tiles.TileJarFillable;
import thaumcraft.common.tiles.TileTubeBuffer;
import thaumicenergistics.api.ITransportPermissions;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;

public final class EssentiaTileContainerHelper {
    public static final EssentiaTileContainerHelper instance = new EssentiaTileContainerHelper();
    public final ITransportPermissions perms = ThEApi.instance().transportPermissions();

    public FluidStack extractFromContainer(IAspectContainer container, FluidStack request, Actionable mode) {
        if (!this.perms.canExtractFromAspectContainerTile(container)) {
            return null;
        }
        if (request == null || request.getFluid() == null || request.amount == 0) {
            return null;
        }
        Fluid fluid = request.getFluid();
        if (!(fluid instanceof GaseousEssentia)) {
            return null;
        }
        Aspect gasAspect = ((GaseousEssentia)fluid).getAspect();
        long amountToDrain_EU = EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(request.amount);
        return this.extractFromContainer(container, (int)amountToDrain_EU, gasAspect, mode);
    }

    public FluidStack extractFromContainer(IAspectContainer container, int amountToDrain_EU, Aspect aspectToDrain, Actionable mode) {
        if (!this.perms.canExtractFromAspectContainerTile(container)) {
            return null;
        }
        if (amountToDrain_EU == 0) {
            return null;
        }
        int containerAmount = 0;
        if (container instanceof TileEssentiaReservoir) {
            containerAmount = container.getAspects().getAmount(aspectToDrain);
        } else {
            AspectStack containerStack = this.getAspectStackFromContainer(container);
            if (containerStack == null || aspectToDrain != containerStack.aspect) {
                return null;
            }
            containerAmount = (int)containerStack.amount;
        }
        GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspectToDrain);
        if (essentiaGas == null) {
            return null;
        }
        if (containerAmount == 0) {
            return null;
        }
        if (amountToDrain_EU > containerAmount) {
            amountToDrain_EU = containerAmount;
        }
        if (mode == Actionable.MODULATE) {
            container.takeFromContainer(aspectToDrain, amountToDrain_EU);
        }
        return new FluidStack((Fluid)essentiaGas, (int)EssentiaConversionHelper.instance.convertEssentiaAmountToFluidAmount(amountToDrain_EU));
    }

    public Aspect getAspectInContainer(IAspectContainer container) {
        AspectStack containerStack = this.getAspectStackFromContainer(container);
        if (containerStack == null) {
            return null;
        }
        return containerStack.aspect;
    }

    public AspectStack getAspectStackFromContainer(IAspectContainer container) {
        if (container == null) {
            return null;
        }
        AspectList aspectList = container.getAspects();
        if (aspectList == null) {
            return null;
        }
        AspectStack aspectStack = new AspectStack();
        aspectStack.aspect = aspectList.getAspectsSortedAmount()[0];
        if (aspectStack.aspect == null) {
            return null;
        }
        aspectStack.amount = aspectList.getAmount(aspectStack.aspect);
        return aspectStack;
    }

    public List<AspectStack> getAspectStacksFromContainer(IAspectContainer container) {
        ArrayList<AspectStack> stacks = new ArrayList<AspectStack>();
        if (container == null) {
            return stacks;
        }
        AspectList aspectList = container.getAspects();
        if (aspectList == null) {
            return stacks;
        }
        for (Map.Entry essentia : aspectList.aspects.entrySet()) {
            if (essentia == null || (Integer)essentia.getValue() == 0) continue;
            stacks.add(new AspectStack((Aspect)essentia.getKey(), ((Integer)essentia.getValue()).intValue()));
        }
        return stacks;
    }

    public int getContainerCapacity(IAspectContainer container) {
        int capacity = 0;
        if (container instanceof TileJarFillable) {
            capacity = ((TileJarFillable)container).maxAmount;
        } else if (container instanceof TileAlembic) {
            capacity = ((TileAlembic)container).maxAmount;
        } else if (container instanceof TileEssentiaReservoir) {
            capacity = ((TileEssentiaReservoir)container).maxAmount;
        }
        return capacity;
    }

    public int getContainerStoredAmount(IAspectContainer container) {
        int stored = 0;
        if (container instanceof TileJarFillable) {
            stored = ((TileJarFillable)container).amount;
        } else if (container instanceof TileAlembic) {
            stored = ((TileAlembic)container).amount;
        } else if (container instanceof TileEssentiaReservoir) {
            for (AspectStack essentia : this.getAspectStacksFromContainer(container)) {
                if (essentia == null) continue;
                stored += (int)essentia.amount;
            }
        }
        return stored;
    }

    public long injectIntoContainer(IAspectContainer container, IAEFluidStack fluidStack, Actionable mode) {
        if (fluidStack == null) {
            return 0L;
        }
        if (!this.perms.canInjectToAspectContainerTile(container)) {
            return 0L;
        }
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof GaseousEssentia)) {
            return 0L;
        }
        Aspect gasAspect = ((GaseousEssentia)fluid).getAspect();
        long amountToFill = EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize());
        return this.injectIntoContainer(container, (int)amountToFill, gasAspect, mode);
    }

    public long injectIntoContainer(IAspectContainer container, int amountToFillInEssentiaUnits, Aspect aspectToFill, Actionable mode) {
        if (!this.perms.canInjectToAspectContainerTile(container)) {
            return 0L;
        }
        AspectStack storedEssentia = this.getAspectStackFromContainer(container);
        if (storedEssentia != null && container instanceof TileJarFillable ? aspectToFill != storedEssentia.aspect : !container.doesContainerAccept(aspectToFill)) {
            return 0L;
        }
        int containerCurrentCapacity = this.getContainerCapacity(container) - this.getContainerStoredAmount(container);
        if (amountToFillInEssentiaUnits > containerCurrentCapacity) {
            amountToFillInEssentiaUnits = containerCurrentCapacity;
        }
        if (mode == Actionable.MODULATE) {
            container.addToContainer(aspectToFill, amountToFillInEssentiaUnits);
        }
        return EssentiaConversionHelper.instance.convertEssentiaAmountToFluidAmount(amountToFillInEssentiaUnits);
    }

    public void registerThaumcraftContainers() {
        this.perms.addAspectContainerTileToExtractPermissions(TileAlembic.class);
        this.perms.addAspectContainerTileToExtractPermissions(TileCentrifuge.class);
        this.perms.addAspectContainerTileToExtractPermissions(TileJarFillable.class);
        this.perms.addAspectContainerTileToInjectPermissions(TileJarFillable.class);
        this.perms.addAspectContainerTileToExtractPermissions(TileTubeBuffer.class);
        this.perms.addAspectContainerTileToExtractPermissions(TileEssentiaReservoir.class);
        this.perms.addAspectContainerTileToInjectPermissions(TileEssentiaReservoir.class);
        this.perms.addAspectContainerTileToExtractPermissions(TileAlchemyFurnaceAdvancedNozzle.class);
    }
}

