/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.implementaion;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.core.localization.PlayerMessages;
import appeng.tile.misc.TileSecurity;
import appeng.tile.networking.TileWireless;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.api.Blocks;
import thaumicenergistics.api.IConfig;
import thaumicenergistics.api.IEssentiaGas;
import thaumicenergistics.api.ITransportPermissions;
import thaumicenergistics.api.IWirelessEssentiaTerminal;
import thaumicenergistics.api.Items;
import thaumicenergistics.api.Parts;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.implementaion.ThEBlocks;
import thaumicenergistics.implementaion.ThEItems;
import thaumicenergistics.implementaion.ThEParts;
import thaumicenergistics.implementaion.ThETransportPermissions;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.inventory.HandlerWirelessEssentiaTerminal;

public class API
extends ThEApi {
    private final ThEBlocks blocks = new ThEBlocks();
    private final ThEItems items = new ThEItems();
    private final ThEParts parts = new ThEParts();
    private final List<IEssentiaGas> essentiaGases = new ArrayList<IEssentiaGas>();
    private final ThETransportPermissions transportPermissions = new ThETransportPermissions();
    public static final API instance = new API();

    private API() {
    }

    @Override
    public Blocks blocks() {
        return this.blocks;
    }

    @Override
    public IConfig config() {
        return ThaumicEnergistics.config;
    }

    @Override
    public long convertEssentiaAmountToFluidAmount(long essentiaAmount) {
        return EssentiaConversionHelper.instance.convertEssentiaAmountToFluidAmount(essentiaAmount);
    }

    @Override
    public long convertFluidAmountToEssentiaAmount(long milibuckets) {
        return EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(milibuckets);
    }

    @Override
    public ImmutableList<List<IEssentiaGas>> essentiaGases() {
        if (this.essentiaGases.size() != GaseousEssentia.gasList.size()) {
            this.essentiaGases.clear();
            Iterator<Map.Entry<Aspect, GaseousEssentia>> iterator = GaseousEssentia.gasList.entrySet().iterator();
            while (iterator.hasNext()) {
                this.essentiaGases.add(iterator.next().getValue());
            }
        }
        return ImmutableList.of(this.essentiaGases);
    }

    @Override
    public Items items() {
        return this.items;
    }

    @Override
    public void openWirelessTerminalGui(EntityPlayer player, IWirelessEssentiaTerminal terminalInterface) {
        IGrid hostGrid;
        long encryptionKey;
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack wirelessTerminal = player.func_70694_bm();
        if (wirelessTerminal == null) {
            return;
        }
        if (terminalInterface.getAECurrentPower(wirelessTerminal) == 0.0) {
            player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
            return;
        }
        if (!HandlerWirelessEssentiaTerminal.isTerminalLinked(terminalInterface, wirelessTerminal)) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        try {
            encryptionKey = Long.parseLong(terminalInterface.getEncryptionKey(wirelessTerminal));
        }
        catch (NumberFormatException e) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        ILocatable source = AEApi.instance().registries().locatable().getLocatableBy(encryptionKey);
        if (!(source instanceof TileSecurity)) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        TileSecurity securityHost = (TileSecurity)source;
        try {
            hostGrid = securityHost.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        }
        catch (Exception e) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
            return;
        }
        IMachineSet accessPoints = hostGrid.getMachines(TileWireless.class);
        for (IGridNode APNode : accessPoints) {
            IWirelessAccessPoint AP = (IWirelessAccessPoint)APNode.getMachine();
            if (!AP.isActive() || !HandlerWirelessEssentiaTerminal.isAPInRangeOfPlayer(AP.getLocation(), AP.getRange(), player)) continue;
            ThEGuiHandler.launchGui(40, player, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, new Object[]{new HandlerWirelessEssentiaTerminal(player, AP, terminalInterface, wirelessTerminal)});
            return;
        }
        if (accessPoints.isEmpty()) {
            player.func_145747_a(PlayerMessages.CommunicationError.get());
        } else {
            player.func_145747_a(PlayerMessages.OutOfRange.get());
        }
    }

    @Override
    public Parts parts() {
        return this.parts;
    }

    @Override
    public ITransportPermissions transportPermissions() {
        return this.transportPermissions;
    }
}

