/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerPartEssentiaIOBus;
import thaumicenergistics.gui.abstraction.AbstractGuiBase;
import thaumicenergistics.gui.buttons.ButtonRedstoneModes;
import thaumicenergistics.gui.widget.AbstractWidget;
import thaumicenergistics.gui.widget.WidgetAspectSlot;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.network.IAspectSlotGui;
import thaumicenergistics.network.packet.server.PacketServerEssentiaIOBus;
import thaumicenergistics.parts.AEPartEssentiaExportBus;
import thaumicenergistics.parts.AEPartEssentiaIO;
import thaumicenergistics.parts.AEPartEssentiaImportBus;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.GuiTextureManager;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaIO
extends AbstractGuiBase
implements WidgetAspectSlot.IConfigurable,
IAspectSlotGui {
    private static final int FILTER_GRID_SIZE = 3;
    private static final byte[] WIDGET_CONFIG_BYTES = new byte[]{2, 1, 2, 1, 0, 1, 2, 1, 2};
    private static final int WIDGET_X_POSITION = 61;
    private static final int WIDGET_Y_POSITION = 21;
    private static final int GUI_HEIGHT = 184;
    private static final int GUI_WIDTH_NO_TOOL = 211;
    private static final int GUI_WIDTH_WITH_TOOL = 246;
    private static final int GUI_MAIN_WIDTH = 176;
    private static final int GUI_UPGRADES_WIDTH = 35;
    private static final int GUI_UPGRADES_HEIGHT = 86;
    private static final int REDSTONE_CONTROL_BUTTON_POS_X = -18;
    private static final int REDSTONE_CONTROL_BUTTON_POS_Y = 2;
    private static final int REDSTONE_CONTROL_BUTTON_SIZE = 16;
    private static final int REDSTONE_CONTROL_BUTTON_ID = 0;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 5;
    private AEPartEssentiaIO part;
    private EntityPlayer player;
    private byte filterSize;
    private List<WidgetAspectSlot> aspectSlotList = new ArrayList<WidgetAspectSlot>();
    private List<Aspect> filteredAspects = new ArrayList<Aspect>();
    private boolean redstoneControlled;
    private boolean hasNetworkTool;
    private RedstoneMode redstoneMode = RedstoneMode.HIGH_SIGNAL;
    private final String guiTitle;

    public GuiEssentiaIO(AEPartEssentiaIO partBus, EntityPlayer player) {
        super(new ContainerPartEssentiaIOBus(partBus, player));
        this.part = partBus;
        this.player = player;
        this.hasNetworkTool = ((ContainerPartEssentiaIOBus)this.field_147002_h).hasNetworkTool();
        this.field_146999_f = this.hasNetworkTool ? 246 : 211;
        this.field_147000_g = 184;
        this.guiTitle = partBus instanceof AEPartEssentiaImportBus ? AEPartsEnum.EssentiaImportBus.getLocalizedName() : (partBus instanceof AEPartEssentiaExportBus ? AEPartsEnum.EssentiaExportBus.getLocalizedName() : "");
    }

    @Override
    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_IO_BUS.getTexture());
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 246, 184);
        } else {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 184);
            this.func_73729_b(this.field_147003_i + 176, this.field_147009_r, 176, 0, 35, 86);
        }
        super.func_146976_a(alpha, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (WidgetAspectSlot aspectSlot : this.aspectSlotList) {
            if (!aspectSlot.isMouseOverWidget(mouseX, mouseY)) continue;
            Aspect itemAspect = EssentiaItemContainerHelper.instance.getAspectInContainer(this.player.field_71071_by.func_70445_o());
            if (itemAspect != null && this.filteredAspects.contains(itemAspect)) {
                return;
            }
            aspectSlot.mouseClicked(itemAspect);
            break;
        }
    }

    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            new PacketServerEssentiaIOBus().createRequestChangeRedstoneMode(this.player, this.part).sendPacketToServer();
        }
    }

    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.guiTitle, 6, 5, 0);
        boolean hoverUnderlayRendered = false;
        WidgetAspectSlot slotUnderMouse = null;
        for (int i = 0; i < 9; ++i) {
            WidgetAspectSlot slotWidget = this.aspectSlotList.get(i);
            if (!hoverUnderlayRendered && slotWidget.canRender() && slotWidget.isMouseOverWidget(mouseX, mouseY)) {
                slotWidget.drawMouseHoverUnderlay();
                slotUnderMouse = slotWidget;
                hoverUnderlayRendered = true;
            }
            slotWidget.drawWidget();
        }
        if (slotUnderMouse != null) {
            slotUnderMouse.getTooltip(this.tooltip);
        } else {
            this.addTooltipFromButtons(mouseX, mouseY);
        }
        this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, true);
    }

    @Override
    public byte getConfigState() {
        return this.filterSize;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = row * 3 + column;
                int xPos = 61 + column * AbstractWidget.WIDGET_SIZE;
                int yPos = 21 + row * AbstractWidget.WIDGET_SIZE;
                this.aspectSlotList.add(new WidgetAspectSlot(this, this.player, this.part, index, xPos, yPos, this, WIDGET_CONFIG_BYTES[index]));
            }
        }
        new PacketServerEssentiaIOBus().createRequestFullUpdate(this.player, this.part).sendPacketToServer();
    }

    public void onReceiveFilterSize(byte filterSize) {
        this.part.receiveFilterSize(filterSize);
        this.filterSize = filterSize;
        for (int i = 0; i < this.aspectSlotList.size(); ++i) {
            WidgetAspectSlot slot = this.aspectSlotList.get(i);
            if (slot.canRender()) continue;
            slot.setAspect(null);
        }
    }

    public void onReceiveRedstoneControlled(boolean newRedstoneControled) {
        if (this.redstoneControlled != newRedstoneControled) {
            if (this.redstoneControlled) {
                this.field_146292_n.clear();
            } else {
                this.field_146292_n.add(new ButtonRedstoneModes(0, this.field_147003_i + -18, this.field_147009_r + 2, 16, 16, this.redstoneMode, false));
            }
            this.redstoneControlled = newRedstoneControled;
        }
    }

    public void onReceiveRedstoneMode(RedstoneMode redstoneMode) {
        if (this.redstoneControlled && this.field_146292_n.size() > 0) {
            ((ButtonRedstoneModes)((Object)this.field_146292_n.get(0))).setRedstoneMode(redstoneMode);
        }
        this.redstoneMode = redstoneMode;
    }

    @Override
    public void updateAspects(List<Aspect> aspectList) {
        this.part.receiveFilterList(aspectList);
        int count = Math.min(this.aspectSlotList.size(), aspectList.size());
        for (int i = 0; i < count; ++i) {
            this.aspectSlotList.get(i).setAspect(aspectList.get(i));
        }
        this.filteredAspects = aspectList;
    }
}

