/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.tconstruct;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mantle.utils.ItemMetaWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.AlloyMix;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.DryingRackRecipes;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolMaterial;

public class TConstructHelper {
    public static HashMap<String, Integer> mappings = new HashMap();
    public static List<AlloyMix> alloys = null;
    public static ArrayList<CastingRecipe> basinCasting = null;
    public static ArrayList<CastingRecipe> tableCasting = null;
    public static Map<ItemMetaWrapper, FluidStack> smeltingList = null;
    public static Map<ItemMetaWrapper, Integer> temperatureList = null;
    public static Map<ItemMetaWrapper, ItemStack> renderIndex = null;
    public static List<ItemModifier> modifiers = null;
    public static List<ItemModifier> modifiers_clone = null;

    private TConstructHelper() {
    }

    public static int getIDFromString(String material) {
        if (!mappings.containsKey(material)) {
            return -1;
        }
        return mappings.get(material);
    }

    public static DryingRackRecipes.DryingRecipe getDryingRecipe(ItemStack input, int time, ItemStack output) {
        try {
            Constructor constructor = DryingRackRecipes.DryingRecipe.class.getDeclaredConstructor(ItemStack.class, Integer.TYPE, ItemStack.class);
            constructor.setAccessible(true);
            return (DryingRackRecipes.DryingRecipe)constructor.newInstance(input, time, output);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NullPointerException("Failed to instantiate DryingRecipe");
        }
    }

    public static String getMaterialFromID(int id) {
        return ((ToolMaterial)TConstructRegistry.toolMaterials.get((Object)Integer.valueOf((int)id))).materialName;
    }

    public static PatternBuilder.ItemKey getItemKey(Item item, int damage, int value, String material) {
        try {
            Constructor constructor = PatternBuilder.ItemKey.class.getDeclaredConstructor(ItemStack.class, Integer.TYPE, Integer.TYPE, String.class);
            constructor.setAccessible(true);
            return (PatternBuilder.ItemKey)constructor.newInstance(item, damage, value, material);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NullPointerException("Failed to instantiate ItemKey");
        }
    }

    static {
        try {
            alloys = Smeltery.getAlloyList();
            smeltingList = Smeltery.getSmeltingList();
            temperatureList = Smeltery.getTemperatureList();
            renderIndex = Smeltery.getRenderIndex();
            basinCasting = TConstructRegistry.getBasinCasting().getCastingRecipes();
            tableCasting = TConstructRegistry.getTableCasting().getCastingRecipes();
            modifiers = ModifyBuilder.instance.itemModifiers;
            modifiers_clone = new ArrayList<ItemModifier>(modifiers);
            for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
                mappings.put(((ToolMaterial)entry.getValue()).materialName, (Integer)entry.getKey());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

