/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.images;

import exnihilo.ExNihilo;
import exnihilo.images.ImageManipulator;
import exnihilo.registries.helpers.Color;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class TextureDynamic
extends TextureAtlasSprite {
    private ResourceLocation template;
    private ResourceLocation base;
    private Color color;

    public TextureDynamic(String name, ResourceLocation base, ResourceLocation template, Color color) {
        super(name);
        this.template = template;
        this.base = base;
        this.color = color;
    }

    public static String getTextureName(String name) {
        return "exnihilo:" + name;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        try {
            manager.func_110536_a(location);
        }
        catch (Exception e) {
            return true;
        }
        ExNihilo.log.info("Icon: " + this.template + " was overwritten by a texturepack or embedded resource.");
        return false;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        try {
            BufferedImage imgBase;
            BufferedImage[] imgFinal = new BufferedImage[1 + mipmapLevels];
            imgFinal[0] = this.tryLoadImage(manager, this.template);
            if (this.color != null) {
                imgFinal[0] = ImageManipulator.Recolor(imgFinal[0], this.color);
            }
            if (this.base != null && (imgBase = this.tryLoadImage(manager, this.base)) != null) {
                imgFinal[0] = ImageManipulator.Composite(imgBase, imgFinal[0]);
            }
            this.func_147964_a(imgFinal, null, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J > 1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    private BufferedImage tryLoadImage(IResourceManager manager, ResourceLocation location) {
        try {
            IResource res = manager.func_110536_a(location);
            BufferedImage imgOutput = ImageIO.read(res.func_110527_b());
            return imgOutput;
        }
        catch (Exception e) {
            ExNihilo.log.error("Failed to load image: " + location.toString());
            return null;
        }
    }
}

